/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StateStatus;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;

public class ActionStore
extends ShadowNoFileLockStore {
    private static boolean checkSync = false;

    @Override
    public int typeIs() {
        return 0;
    }

    @Override
    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        int theState = -1;
        if (this.storeValid()) {
            String path = this.genPathName(objUid, tName, 11);
            if (this.exists(path)) {
                theState = 1;
            }
            path = null;
        }
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.internal.arjuna.objectstore.ActionStore_1", new Object[]{objUid, tName, StateStatus.stateStatusString(theState)});
        }
        return theState;
    }

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.commit_state(" + objUid + ", " + tName + ")");
        }
        boolean result = false;
        if (!this.storeValid()) {
            return false;
        }
        if (this.currentState(objUid, tName) == 1) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.hide_state(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.reveal_state(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.read_committed(" + storeUid + ", " + tName + ")");
        }
        return super.read_committed(storeUid, tName);
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.read_uncommitted(" + u + ", " + tn + ")");
        }
        return null;
    }

    @Override
    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.remove_committed(" + storeUid + ", " + tName + ")");
        }
        return super.remove_committed(storeUid, tName);
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.remove_uncommitted(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.write_committed(" + storeUid + ", " + tName + ")");
        }
        return super.write_committed(storeUid, tName, state);
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("ActionStore.write_uncommitted(" + u + ", " + tn + ", " + s + ")");
        }
        return false;
    }

    public ActionStore(String locationOfStore) {
        this(locationOfStore, 13);
    }

    public ActionStore(String locationOfStore, int shareStatus) {
        super(shareStatus);
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLogger.warn(e);
            }
            super.makeInvalid();
            throw new FatalError(e.toString(), e);
        }
    }

    public ActionStore() {
        this(13);
    }

    public ActionStore(int shareStatus) {
        this(arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot(), shareStatus);
    }

    @Override
    protected synchronized boolean setupStore(String location) throws ObjectStoreException {
        if (!checkSync) {
            if (arjPropertyManager.getObjectStoreEnvironmentBean().isTransactionSync()) {
                this.syncOn();
            } else {
                this.syncOff();
            }
        }
        checkSync = true;
        return super.setupStore(location);
    }
}

