/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.xa.XidImple;
import javax.transaction.xa.Xid;

public class JTATransactionLogXAResourceOrphanFilter
implements XAResourceOrphanFilter {
    @Override
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        if (xid.getFormatId() != 131076) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        if (this.transactionLog(xid)) {
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        return XAResourceOrphanFilter.Vote.ABSTAIN;
    }

    private boolean transactionLog(Xid xid) {
        ObjectStore transactionStore = TxControl.getStore();
        String transactionType = new AtomicAction().type();
        XidImple theXid = new XidImple(xid);
        Uid u = theXid.getTransactionUid();
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("Checking whether Xid " + theXid + " exists in ObjectStore.");
        }
        if (!u.equals(Uid.nullUid())) {
            try {
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug("Looking for " + u + " and " + transactionType);
                }
                if (transactionStore.currentState(u, transactionType) != -1) {
                    if (jtaLogger.logger.isDebugEnabled()) {
                        jtaLogger.logger.debug("Found record for " + theXid);
                    }
                    return true;
                }
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug("No record found for " + theXid);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (jtaLogger.logger.isInfoEnabled()) {
            jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.notaxid", new Object[]{xid});
        }
        return false;
    }
}

