/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore;

import com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.exceptions.RollbackException;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.io.Serializable;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImple
implements TransactionSynchronizationRegistry,
Serializable {
    private static final long serialVersionUID = 1L;

    public Object getTransactionKey() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getTransactionKey");
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        TransactionImple transactionImple = null;
        try {
            transactionImple = (TransactionImple)tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_transaction_arjunacore_systemexception(), e);
        }
        if (transactionImple == null) {
            return null;
        }
        return transactionImple.get_uid();
    }

    public void putResource(Object key, Object value) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.putResource");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImple transactionImple = this.getTransactionImple();
        transactionImple.putTxLocalResource(key, value);
    }

    public Object getResource(Object key) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getResource");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImple transactionImple = this.getTransactionImple();
        return transactionImple.getTxLocalResource(key);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.registerInterposedSynchronization");
        }
        TransactionImple transactionImple = this.getTransactionImple();
        try {
            transactionImple.registerSynchronizationImple(new SynchronizationImple(synchronization, true));
        }
        catch (javax.transaction.RollbackException e) {
            throw new RollbackException(jtaLogger.i18NLogger.get_transaction_arjunacore_syncrollbackexception(), e);
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_transaction_arjunacore_systemexception(), e);
        }
    }

    public int getTransactionStatus() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getTransactionStatus");
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        try {
            return tm.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_transaction_arjunacore_systemexception(), e);
        }
    }

    public void setRollbackOnly() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.setRollbackOnly");
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        try {
            Transaction transaction = tm.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException();
            }
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_transaction_arjunacore_systemexception(), e);
        }
    }

    public boolean getRollbackOnly() {
        TransactionImple transactionImple;
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getRollbackOnly");
        }
        if ((transactionImple = this.getTransactionImple()) == null) {
            throw new IllegalStateException();
        }
        try {
            return transactionImple.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_transaction_arjunacore_systemexception(), e);
        }
    }

    private TransactionImple getTransactionImple() throws IllegalStateException {
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        TransactionImple transactionImple = null;
        try {
            transactionImple = (TransactionImple)tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_transaction_arjunacore_systemexception(), e);
        }
        if (transactionImple == null) {
            throw new IllegalStateException();
        }
        return transactionImple;
    }
}

