/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates,
 * and individual contributors as indicated by the @author tags.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2010,
 * @author JBoss, by Red Hat.
 */
package com.arjuna.ats.arjuna.logging;

import org.jboss.logging.Logger;
import static org.jboss.logging.Logger.Level.*;
import java.text.MessageFormat;
import com.arjuna.ats.arjuna.common.Uid;

/**
 * i18n log messages for the arjuna module.
 * This class is autogenerated. Don't mess with it.
 *
 * @author Jonathan Halliday (jonathan.halliday@redhat.com) 2010-06
 */
public class arjunaI18NLoggerImpl implements arjunaI18NLogger {

	private final Logger logger;

	arjunaI18NLoggerImpl(Logger logger) {
		this.logger = logger;
	}

	public void warn_ActivationRecord_1() {
		logger.logv(WARN, "ARJUNA-12001 ActivationRecord::set_value() called illegally", (Object)null);
	}

	public void warn_ActivationRecord_2(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12002 Invocation of ActivationRecord::restore_state for {0} inappropriate - ignored for {1}", arg0, arg1);
	}

	public void warn_CadaverRecord_1(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12003 Attempted abort operation on deleted object id {0} of type {1} ignored", arg0, arg1);
	}

	public void warn_DisposeRecord_1() {
		logger.logv(WARN, "ARJUNA-12004 DisposeRecord::save_state - type of store is unknown", (Object)null);
	}

	public void warn_DisposeRecord_2() {
		logger.logv(WARN, "ARJUNA-12005 DisposeRecord::save_state - failed", (Object)null);
	}

	public void warn_DisposeRecord_3() {
		logger.logv(WARN, "ARJUNA-12006 DisposeRecord::save_state - no object store defined.", (Object)null);
	}

	public void warn_DisposeRecord_4(String arg0) {
		logger.logv(WARN, "ARJUNA-12007 DisposeRecord::restore_state - invalid store type {0}", arg0);
	}

	public void warn_DisposeRecord_5(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12008 DisposeRecord::topLevelCommit - exception while deleting state", (Object)null);
	}

	public void warn_PersistenceRecord_10() {
		logger.logv(WARN, "ARJUNA-12009 PersistenceRecord::restore_state: Failed to unpack object store type", (Object)null);
	}

	public void warn_PersistenceRecord_11() {
		logger.logv(WARN, "ARJUNA-12010 PersistenceRecord::save_state - type of store is unknown", (Object)null);
	}

	public void warn_PersistenceRecord_14() {
		logger.logv(WARN, "ARJUNA-12011 PersistenceRecord::save_state - packing top level state failed", (Object)null);
	}

	public void warn_PersistenceRecord_15() {
		logger.logv(WARN, "ARJUNA-12012 PersistenceRecord::save_state - failed", (Object)null);
	}

	public void warn_PersistenceRecord_16() {
		logger.logv(WARN, "ARJUNA-12013 PersistenceRecord::save_state - no object store defined for object", (Object)null);
	}

	public void warn_PersistenceRecord_19() {
		logger.logv(WARN, "ARJUNA-12015 PersistenceRecord::topLevelAbort() - Could not remove state from object store!", (Object)null);
	}

	public void warn_PersistenceRecord_2(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12016 PersistenceRecord::topLevelCommit - commit_state call failed for {0}", arg0);
	}

	public void warn_PersistenceRecord_20(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12017 PersistenceRecord::topLevelAbort() - Received ObjectStoreException", (Object)null);
	}

	public void warn_PersistenceRecord_21(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12018 PersistenceRecord.topLevelPrepare - write_uncommitted error", (Object)null);
	}

	public void warn_PersistenceRecord_3() {
		logger.logv(WARN, "ARJUNA-12019 PersistenceRecord::topLevelCommit - no state to commit!", (Object)null);
	}

	public void warn_PersistenceRecord_4(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12020 PersistenceRecord::topLevelCommit - caught exception", (Object)null);
	}

	public void warn_PersistenceRecord_5() {
		logger.logv(WARN, "ARJUNA-12021 PersistenceRecord::topLevelCommit - no object store specified!", (Object)null);
	}

	public void warn_PersistenceRecord_6() {
		logger.logv(WARN, "ARJUNA-12022 PersistenceRecord::topLevelCommit - commit_state error", (Object)null);
	}

	public void warn_PersistenceRecord_7() {
		logger.logv(WARN, "ARJUNA-12023 PersistenceRecord deactivate error, object probably already deactivated!", (Object)null);
	}

	public void warn_PersistenceRecord_8() {
		logger.logv(WARN, "ARJUNA-12024 PersistenceRecord.topLevelPrepare - setup error!", (Object)null);
	}

	public void warn_RecoveryRecord_1() {
		logger.logv(WARN, "ARJUNA-12025 RecoveryRecord::setValue not given OutputObjectState.", (Object)null);
	}

	public void warn_RecoveryRecord_2() {
		logger.logv(WARN, "ARJUNA-12026 RecoveryRecord::nestedAbort - restore_state on object failed!", (Object)null);
	}

	public void warn_StateManager_1() {
		logger.logv(WARN, "ARJUNA-12027 StateManager::terminate() should be invoked in every destructor", (Object)null);
	}

	public void warn_StateManager_10() {
		logger.logv(WARN, "ARJUNA-12028 StateManager::modified() invocation on an object whose state has not been restored - activating object", (Object)null);
	}

	public void warn_StateManager_11(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12029 Delete called on object with uid {0} and type {1} within atomic action.", arg0, arg1);
	}

	public void warn_StateManager_12() {
		logger.logv(WARN, "ARJUNA-12030 StateManager.cleanup - could not save_state from terminate!", (Object)null);
	}

	public void warn_StateManager_13() {
		logger.logv(WARN, "ARJUNA-12031 Attempt to use volatile store.", (Object)null);
	}

	public String get_StateManager_14() {
		return "ARJUNA-12032 Volatile store not implemented!";
	}

	public String get_StateManager_15() {
		return "ARJUNA-12033 Invalid object state.";
	}

	public String get_StateManager_16() {
		return "ARJUNA-12034 Invalid object store type:";
	}

	public void warn_StateManager_2(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12035 Activate of object with id = {0} and type {1} unexpectedly failed", arg0, arg1);
	}

	public void warn_StateManager_3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12036 StateManager::deactivate - object store error", (Object)null);
	}

	public void warn_StateManager_4() {
		logger.logv(WARN, "ARJUNA-12037 StateManager::deactivate - save_state error", (Object)null);
	}

	public void warn_StateManager_6(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12038 StateManager.destroy - failed to add abstract record to transaction {0}; check transaction status.", arg0);
	}

	public void warn_StateManager_7(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12039 StateManager.destroy - caught object store exception", (Object)null);
	}

	public void warn_StateManager_8() {
		logger.logv(WARN, "ARJUNA-12040 StateManager.destroy - called on non-persistent or new object!", (Object)null);
	}

	public void warn_StateManager_9() {
		logger.logv(WARN, "ARJUNA-12041 StateManager.restore_state - could not find StateManager state in object state!", (Object)null);
	}

	public void warn_common_Mutex_2() {
		logger.logv(WARN, "ARJUNA-12043 Mutex.unlock - called by non-owning thread!", (Object)null);
	}

	public void warn_common_Uid_1() {
		logger.logv(WARN, "ARJUNA-12044 cannot get local host.", (Object)null);
	}

	public String get_common_Uid_11() {
		return "ARJUNA-12046 Uid.Uid recreate constructor could not recreate Uid!";
	}

	public String get_common_Uid_2() {
		return "ARJUNA-12047 Uid.Uid string constructor could not create nullUid";
	}

	public void warn_common_Uid_3(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12048 Uid general parsing error: {0}", arg0);
	}

	public void fatal_common_Uid_4(String arg0) {
		logger.logv(FATAL, "ARJUNA-12049 Uid.Uid string constructor could not create nullUid for incorrect string: {0}", arg0);
	}

	public String get_common_Uid_5(String arg0) {
		return MessageFormat.format("ARJUNA-12050 Uid.Uid string constructor incorrect: {0}", arg0);
	}

	public void warn_common_Uid_6() {
		logger.logv(WARN, "ARJUNA-12051 Uid.generateHash called for invalid Uid. Will ignore.", (Object)null);
	}

	public void warn_common_Uid_bytes(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12055 Exception thrown creating Uid from bytes!", (Object)null);
	}

	public void warn_common_Uid_getbytes(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12056 Exception thrown getting bytes!", (Object)null);
	}

	public void warn_common_Uid_npe(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12057 Uid.Uid string constructor {0} caught other throwable", arg0);
	}

	public void warn_coordinator_AbstractRecord_npe(String arg0) {
		logger.logv(WARN, "ARJUNA-12058 AbstractRecord.create {0} failed to find record.", arg0);
	}

	public String get_coordinator_ActionHierarchy_1() {
		return "ARJUNA-12059 Memory exhausted.";
	}

	public void warn_coordinator_BasicAction_1(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12060 Action nesting error - deletion of action id {0} invoked while child actions active", arg0);
	}

	public void warn_coordinator_BasicAction_2(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12061 Aborting child {0}", arg0);
	}

	public void warn_coordinator_BasicAction_21(String arg0) {
		logger.logv(WARN, "ARJUNA-12062 BasicAction.restore_state - could not recover {0}", arg0);
	}

	public void warn_coordinator_BasicAction_24() {
		logger.logv(WARN, "ARJUNA-12063 BasicAction.restore_state - error unpacking action status.", (Object)null);
	}

	public void warn_coordinator_BasicAction_29(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12065 BasicAction.Begin of action {0} ignored - incorrect invocation sequence {1}", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_3(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12066 Destructor of still running action id {0} invoked - Aborting", arg0);
	}

	public void warn_coordinator_BasicAction_30(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12067 BasicAction.Begin of action {0} ignored - no parent and set as nested action!", arg0);
	}

	public void warn_coordinator_BasicAction_31(Uid arg0, Uid arg1, String arg2) {
		logger.logv(WARN, "ARJUNA-12068 BasicAction.Begin of action {0} ignored - parent action {1} is not running: {2}", arg0, arg1, arg2);
	}

	public void warn_coordinator_BasicAction_33(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12070 End called on non-running atomic action {0}", arg0);
	}

	public void warn_coordinator_BasicAction_34(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12071 End called on already committed atomic action {0}", arg0);
	}

	public void warn_coordinator_BasicAction_35(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12072 End called illegally on atomic action {0}", arg0);
	}

	public void warn_coordinator_BasicAction_36(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12073 BasicAction.End() - prepare phase of action-id {0} failed.", arg0);
	}

	public void warn_coordinator_BasicAction_37(String arg0) {
		logger.logv(WARN, "ARJUNA-12074 Received heuristic: {0} .", arg0);
	}

	public void warn_coordinator_BasicAction_38() {
		logger.logv(WARN, "ARJUNA-12075 Action Aborting", (Object)null);
	}

	public void warn_coordinator_BasicAction_39(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12076 Abort called on non-running atomic action {0}", arg0);
	}

	public void warn_coordinator_BasicAction_40(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12077 Abort called on already aborted atomic action {0}", arg0);
	}

	public void warn_coordinator_BasicAction_41(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12078 Abort called illegaly on atomic action {0}", arg0);
	}

	public void warn_coordinator_BasicAction_42(Uid arg0, String arg1, String arg2) {
		logger.logv(WARN, "ARJUNA-12079 BasicAction {0} - non-empty ( {1} ) pendingList {2}", arg0, arg1, arg2);
	}

	public void warn_coordinator_BasicAction_43(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12080 Transaction {0} marked as rollback only. Will abort.", arg0);
	}

	public void warn_coordinator_BasicAction_44() {
		logger.logv(WARN, "ARJUNA-12081 Cannot force parent to rollback - no handle!", (Object)null);
	}

	public void warn_coordinator_BasicAction_45(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12082 BasicAction::prepare - creating intentions list failed for {0}", arg0);
	}

	public void warn_coordinator_BasicAction_46(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12083 BasicAction::prepare - intentions list write failed for {0}", arg0);
	}

	public void warn_coordinator_BasicAction_47(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12084 One-phase commit of action {0} received heuristic decision: {1}", arg0, arg1);
	}

	public void fatal_coordinator_BasicAction_48() {
		logger.logv(FATAL, "ARJUNA-12085 BasicAction.onePhaseCommit failed - no object store for atomic action state!", (Object)null);
	}

	public void warn_coordinator_BasicAction_49(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12086 Prepare phase of nested action {0} received inconsistent outcomes.", arg0);
	}

	public void warn_coordinator_BasicAction_5(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12087 Activate of atomic action with id {0} and type {1} unexpectedly failed, could not load state.", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_50(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12088 Prepare phase of action {0} received heuristic decision: {1}", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_52(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12089 Top-level abort of action {0} received heuristic decision: {1}", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_53(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12090 Nested abort of action {0} received heuristic decision: {1}", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_54(Uid arg0, String arg1, String arg2) {
		logger.logv(WARN, "ARJUNA-12091 Top-level abort of action {0} received {1} from {2}", arg0, arg1, arg2);
	}

	public void warn_coordinator_BasicAction_55(Uid arg0, String arg1, String arg2) {
		logger.logv(WARN, "ARJUNA-12092 Nested abort of action {0} received {1} from {2}", arg0, arg1, arg2);
	}

	public void warn_coordinator_BasicAction_56(Uid arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12093 BasicAction.checkIsCurrent {0} - terminating non-current transaction: {1}", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_57(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12094 Commit of action id {0} invoked while multiple threads active within it.", arg0);
	}

	public void warn_coordinator_BasicAction_58(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12095 Abort of action id {0} invoked while multiple threads active within it.", arg0);
	}

	public void warn_coordinator_BasicAction_59(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12096 Commit of action id {0} invoked while child actions active", arg0);
	}

	public void warn_coordinator_BasicAction_5a(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12097 Deactivate of atomic action with id {0} and type {1} unexpectedly failed, could not save state.", arg0, arg1);
	}

	public void warn_coordinator_BasicAction_60(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12098 Abort of action id {0} invoked while child actions active", arg0);
	}

	public void warn_coordinator_BasicAction_61(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12099 Aborting child: {0}", arg0);
	}

	public void warn_coordinator_BasicAction_62(String arg0) {
		logger.logv(WARN, "ARJUNA-12100 Now aborting self: {0}", arg0);
	}

	public void warn_coordinator_BasicAction_64() {
		logger.logv(WARN, "ARJUNA-12101 BasicAction.updateState - Could not create ObjectState for failedList", (Object)null);
	}

	public void warn_coordinator_BasicAction_65() {
		logger.logv(WARN, "ARJUNA-12102 BasicAction.End - Could not write failed list", (Object)null);
	}

	public void warn_coordinator_BasicAction_68() {
		logger.logv(WARN, "ARJUNA-12103 (Internal) BasicAction.merge - record rejected", (Object)null);
	}

	public String get_coordinator_BasicAction_69() {
		return "ARJUNA-12104 No object store for:";
	}

	public void warn_coordinator_BasicAction_70(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12105 Could not remove intentions list:", (Object)null);
	}

	public void warn_coordinator_CheckedAction_1(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12107 CheckedAction::check - atomic action {0} commiting with {1} threads active!", arg0, arg1);
	}

	public void warn_coordinator_CheckedAction_2(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12108 CheckedAction::check - atomic action {0} aborting with {1} threads active!", arg0, arg1);
	}

	public String get_coordinator_TransactionReaper_1() {
		return "ARJUNA-12109 TransactionReaper - attempting to insert an element that is already present.";
	}

	public void warn_coordinator_TransactionReaper_10(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12110 TransactionReaper::check successfuly marked TX {0} as rollback only", arg0);
	}

	public void warn_coordinator_TransactionReaper_11(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12111 TransactionReaper::check failed to mark TX {0}  as rollback only", arg0);
	}

	public void warn_coordinator_TransactionReaper_12(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12112 TransactionReaper::check exception while marking TX {0} as rollback only", arg0);
	}

	public void warn_coordinator_TransactionReaper_13(String arg0, Uid arg1, String arg2) {
		logger.logv(WARN, "ARJUNA-12113 TransactionReaper::doCancellations worker {0} missed interrupt when cancelling TX {1} -- exiting as zombie (zombie count decremented to {2})", arg0, arg1, arg2);
	}

	public void warn_coordinator_TransactionReaper_14(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12114 TransactionReaper::doCancellations worker {0} successfuly marked TX {1} as rollback only", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_15(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12115 TransactionReaper::doCancellations worker {0} failed to mark TX {1}  as rollback only", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_16(String arg0, Uid arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-12116 TransactionReaper::doCancellations worker {0} exception while marking TX {1} as rollback only", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_18(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12117 TransactionReaper::check timeout for TX {0} in state  {1}", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_19() {
		logger.logv(WARN, "ARJUNA-12118 TransactionReaper NORMAL mode is deprecated. Update config to use PERIODIC for equivalent behaviour.", (Object)null);
	}

	public void error_coordinator_TransactionReaper_5(String arg0) {
		logger.logv(ERROR, "ARJUNA-12119 TransactionReaper::check worker zombie count {0} exceeds specified limit", arg0);
	}

	public void warn_coordinator_TransactionReaper_6(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12120 TransactionReaper::check worker {0} not responding to interrupt when cancelling TX {1} -- worker marked as zombie and TX scheduled for mark-as-rollback", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_7(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12121 TransactionReaper::doCancellations worker {0} successfully canceled TX {1}", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_8(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12122 TransactionReaper::doCancellations worker {0} failed to cancel TX {1} -- rescheduling for mark-as-rollback", arg0, arg1);
	}

	public void warn_coordinator_TransactionReaper_9(String arg0, Uid arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-12123 TransactionReaper::doCancellations worker {0} exception during cancel of TX {1} -- rescheduling for mark-as-rollback", arg0, arg1);
	}

	public void warn_coordinator_TwoPhaseCoordinator_1() {
		logger.logv(WARN, "ARJUNA-12124 TwoPhaseCoordinator.beforeCompletion - attempted rollback_only failed!", (Object)null);
	}

	public void warn_coordinator_TwoPhaseCoordinator_2(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12125 TwoPhaseCoordinator.beforeCompletion - failed for {0}", arg0);
	}

	public void warn_coordinator_TwoPhaseCoordinator_3() {
		logger.logv(WARN, "ARJUNA-12126 TwoPhaseCoordinator.beforeCompletion TwoPhaseCoordinator.afterCompletion called on still running transaction!", (Object)null);
	}

	public void warn_coordinator_TwoPhaseCoordinator_4(String arg0) {
		logger.logv(WARN, "ARJUNA-12127 TwoPhaseCoordinator.afterCompletion - returned failure for {0}", arg0);
	}

	public void warn_coordinator_TwoPhaseCoordinator_4a(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12128 TwoPhaseCoordinator.afterCompletion - failed for {0} with exception", arg0);
	}

	public void warn_coordinator_TwoPhaseCoordinator_4b(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12129 TwoPhaseCoordinator.afterCompletion - failed for {0} with error", arg0);
	}

	public void warn_coordinator_TxControl_1(String arg0) {
		logger.logv(WARN, "ARJUNA-12130 Name of XA node not defined. Using {0}", arg0);
	}

	public void warn_coordinator_TxControl_2(String arg0) {
		logger.logv(WARN, "ARJUNA-12131 Supplied name of node is too long. Using {0}", arg0);
	}

	public void warn_coordinator_TxControl_3(String arg0) {
		logger.logv(WARN, "ARJUNA-12132 Supplied name of node contains reserved character '-'. Using {0}", arg0);
	}

	public String get_StoreManager_invalidtype() {
		return "ARJUNA-12135 Could not create ObjectStore type:";
	}

	public void warn_coordinator_norecordfound(String arg0) {
		logger.logv(WARN, "ARJUNA-12136 Could not recreate abstract record {0}", arg0);
	}

	public void warn_coordinator_notrunning() {
		logger.logv(WARN, "ARJUNA-12137 Cannot begin new transaction as TM is disabled. Marking as rollback-only.", (Object)null);
	}

	public void warn_coordinator_toolong() {
		logger.logv(WARN, "ARJUNA-12138 Node name cannot exceed 64 bytes!", (Object)null);
	}

	public void warn_lastResource_disableWarning() {
		logger.logv(WARN, "ARJUNA-12139 You have chosen to disable the Multiple Last Resources warning. You will see it only once.", (Object)null);
	}

	public void warn_lastResource_disallow(String arg0) {
		logger.logv(WARN, "ARJUNA-12140 Adding multiple last resources is disallowed. Current resource is {0}", arg0);
	}

	public void warn_lastResource_multipleWarning(String arg0) {
		logger.logv(WARN, "ARJUNA-12141 Multiple last resources have been added to the current transaction. This is transactionally unsafe and should not be relied upon. Current resource is {0}", arg0);
	}

	public void warn_lastResource_startupWarning() {
		logger.logv(WARN, "ARJUNA-12142 You have chosen to enable multiple last resources in the transaction manager. This is transactionally unsafe and should not be relied upon.", (Object)null);
	}

	public void warn_objectstore_ObjectStoreType_1(String arg0) {
		logger.logv(WARN, "ARJUNA-12143 unknown store: {0}", arg0);
	}

	public String get_objectstore_ObjectStoreType_2() {
		return "ARJUNA-12144 unknown store:";
	}

	public void warn_recovery_ActionStatusService_5(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12146 ActionStatusService: searching for uid: {0}", arg0);
	}

	public void info_recovery_ActionStatusService_1(String arg0, String arg1, String arg2) {
		logger.logv(INFO, "ARJUNA-12147 transactionType: {0} uid: {1}   Status is {2}", arg0, arg1, arg2);
	}

	public void warn_recovery_ActionStatusService_2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12148 Other Exception", (Object)null);
	}

	public void warn_recovery_ActionStatusService_3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12149 Exception retrieving action status", (Object)null);
	}

	public void info_recovery_ActionStatusService_4(Uid arg0) {
		logger.logv(INFO, "ARJUNA-12150 matching Uid {0} found", arg0);
	}

	public void warn_recovery_ActionStatusService_6(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12151 Exception when accessing transaction store", (Object)null);
	}

	public void warn_recovery_ActionStatusService_7() {
		logger.logv(WARN, "ARJUNA-12152 Connection Lost to Recovery Manager", (Object)null);
	}

	public void warn_recovery_RecoverAtomicAction_2(String arg0) {
		logger.logv(WARN, "ARJUNA-12153 RecoverAtomicAction.replayPhase2: Unexpected status: {0}", arg0);
	}

	public void warn_recovery_RecoverAtomicAction_4(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12154 RecoverAtomicAction: transaction {0} not activated, unable to replay phase 2 commit. Check state has not already been completed.", arg0);
	}

	public void warn_recovery_RecoverAtomicAction_5(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12155 RecoverAtomicAction - tried to move failed activation log {0}", arg0);
	}

	public void info_recovery_RecoveryManager_4(String arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-12159 Connected to recovery manager on {0}:{1}", arg0, arg1);
	}

	public void warn_recovery_TransactionStatusConnectionManager_1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12161 Exception when accessing data store", (Object)null);
	}

	public void warn_recovery_TransactionStatusConnectionManager_2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12162 Object store exception", (Object)null);
	}

	public void info_recovery_TransactionStatusManager_1(String arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-12163 Starting service {0} on port {1}", arg0, arg1);
	}

	public String get_recovery_TransactionStatusManager_13() {
		return "ARJUNA-12167 Invalid host or port";
	}

	public void warn_recovery_TransactionStatusManager_14(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12168 Failed to create server socket on address {0} and port: {1}", arg0, arg1);
	}

	public void warn_recovery_TransactionStatusManager_2() {
		logger.logv(WARN, "ARJUNA-12169 Listener failed", (Object)null);
	}

	public void info_recovery_TransactionStatusManager_3(String arg0, String arg1, String arg2) {
		logger.logv(INFO, "ARJUNA-12170 TransactionStatusManager started on port {0} and host {1} with service {2}", arg0, arg1, arg2);
	}

	public void warn_recovery_TransactionStatusManager_4(String arg0) {
		logger.logv(WARN, "ARJUNA-12171 Class not found: {0}", arg0);
	}

	public void warn_recovery_TransactionStatusManager_5(String arg0) {
		logger.logv(WARN, "ARJUNA-12172 Failed to instantiate service class: {0}", arg0);
	}

	public void warn_recovery_TransactionStatusManager_6(String arg0) {
		logger.logv(WARN, "ARJUNA-12173 Illegal access to service class: {0}", arg0);
	}

	public String get_recovery_TransactionStatusManager_9() {
		return "ARJUNA-12176 Could not get unique port.";
	}

	public String get_state_InputBuffer_1() {
		return "ARJUNA-12177 com.arjuna.ats.arjuna.state.InputBuffer_1 - Invalid input buffer: byte.";
	}

	public String get_state_InputBuffer_10() {
		return "ARJUNA-12178 com.arjuna.ats.arjuna.state.InputBuffer_10 - Invalid input buffer: string.";
	}

	public String get_state_InputBuffer_11() {
		return "ARJUNA-12179 com.arjuna.ats.arjuna.state.InputBuffer_11 - Invalid from buffer";
	}

	public String get_state_InputBuffer_2() {
		return "ARJUNA-12180 com.arjuna.ats.arjuna.state.InputBuffer_2 - Invalid input buffer: bytes.";
	}

	public String get_state_InputBuffer_3() {
		return "ARJUNA-12181 com.arjuna.ats.arjuna.state.InputBuffer_3 - Invalid input buffer: boolean.";
	}

	public String get_state_InputBuffer_4() {
		return "ARJUNA-12182 com.arjuna.ats.arjuna.state.InputBuffer_4 - Invalid input buffer: char.";
	}

	public String get_state_InputBuffer_5() {
		return "ARJUNA-12183 com.arjuna.ats.arjuna.state.InputBuffer_5 - Invalid input buffer: short.";
	}

	public String get_state_InputBuffer_6() {
		return "ARJUNA-12184 com.arjuna.ats.arjuna.state.InputBuffer_6 - Invalid input buffer: int.";
	}

	public String get_state_InputBuffer_7() {
		return "ARJUNA-12185 com.arjuna.ats.arjuna.state.InputBuffer_7 - Invalid input buffer: long.";
	}

	public String get_state_InputBuffer_8() {
		return "ARJUNA-12186 com.arjuna.ats.arjuna.state.InputBuffer_8 - Invalid input buffer: float.";
	}

	public String get_state_InputBuffer_9() {
		return "ARJUNA-12187 com.arjuna.ats.arjuna.state.InputBuffer_9 - Invalid input buffer: double";
	}

	public String get_state_OutputBuffer_1() {
		return "ARJUNA-12188 com.arjuna.ats.arjuna.state.OutputBuffer_1 - Invalid input buffer: byte.";
	}

	public String get_state_OutputBuffer_10() {
		return "ARJUNA-12189 com.arjuna.ats.arjuna.state.OutputBuffer_10 - Invalid input buffer: string.";
	}

	public String get_state_OutputBuffer_11() {
		return "ARJUNA-12190 com.arjuna.ats.arjuna.state.OutputBuffer_11 - Invalid from buffer";
	}

	public String get_state_OutputBuffer_2() {
		return "ARJUNA-12191 com.arjuna.ats.arjuna.state.OutputBuffer_2 - Invalid input buffer: bytes.";
	}

	public String get_state_OutputBuffer_3() {
		return "ARJUNA-12192 com.arjuna.ats.arjuna.state.OutputBuffer_3 - Invalid input buffer: boolean.";
	}

	public String get_state_OutputBuffer_4() {
		return "ARJUNA-12193 com.arjuna.ats.arjuna.state.OutputBuffer_4 - Invalid input buffer: char.";
	}

	public String get_state_OutputBuffer_5() {
		return "ARJUNA-12194 com.arjuna.ats.arjuna.state.OutputBuffer_5 - Invalid input buffer: short.";
	}

	public String get_state_OutputBuffer_6() {
		return "ARJUNA-12195 com.arjuna.ats.arjuna.state.OutputBuffer_6 - Invalid input buffer: int.";
	}

	public String get_state_OutputBuffer_7() {
		return "ARJUNA-12196 com.arjuna.ats.arjuna.state.OutputBuffer_7 - Invalid input buffer: long.";
	}

	public String get_state_OutputBuffer_8() {
		return "ARJUNA-12197 com.arjuna.ats.arjuna.state.OutputBuffer_8 - Invalid input buffer: float.";
	}

	public String get_state_OutputBuffer_9() {
		return "ARJUNA-12198 com.arjuna.ats.arjuna.state.OutputBuffer_9 - Invalid input buffer: double";
	}

	public void info_tools_osb_util_JMXServer_m_1(String arg0) {
		logger.logv(INFO, "ARJUNA-12202 registering bean {0}.", arg0);
	}

	public void info_tools_osb_util_JMXServer_m_2(String arg0) {
		logger.logv(INFO, "ARJUNA-12203 Instance already exists: {0}.", arg0);
	}

	public void warn_tools_osb_util_JMXServer_m_3(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12204 Error registering {0}", arg0);
	}

	public void warn_tools_osb_util_JMXServer_m_5(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12206 Unable to unregister bean {0}", arg0);
	}

	public void warn_tools_osb_util_JMXServer_m_6(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12207 Unable to unregister bean {0}", arg0);
	}

	public void warn_utils_FileLock_4(String arg0) {
		logger.logv(WARN, "ARJUNA-12208 An error occurred while creating file {0}", arg0);
	}

	public void warn_utils_Utility_1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12209 Utility.getDefaultProcess - failed with", (Object)null);
	}

	public void warn_utils_Utility_2() {
		logger.logv(WARN, "ARJUNA-12210 Unable to use InetAddress.getLocalHost() to resolve address.", (Object)null);
	}

	public void warn_ats_atomicaction_1(String arg0) {
		logger.logv(WARN, "ARJUNA-12211 Attempt to suspend a non-AtomicAction transaction. Type is {0}", arg0);
	}

	public void warn_abstractrecords_smf1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12212 StateManagerFriend.forgetAction", (Object)null);
	}

	public void warn_abstractrecords_smf2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12213 StateManagerFriend.destroyed", (Object)null);
	}

	public void warn_abstractrecords_smf3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12214 StateManagerFriend.rememberAction", (Object)null);
	}

	public void warn_common_ClassloadingUtility_1() {
		logger.logv(WARN, "ARJUNA-12215 className is null", (Object)null);
	}

	public void warn_common_ClassloadingUtility_2(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12216 attempt to load {0} threw ClassNotFound. Wrong classloader?", arg0);
	}

	public void warn_common_ClassloadingUtility_3(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-12217 class {0} does not implement {1}", arg0, arg1);
	}

	public void warn_common_ClassloadingUtility_4(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12218 can''t create new instance of {0}", arg0);
	}

	public void warn_common_ClassloadingUtility_5(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12219 can''t access {0}", arg0);
	}

	public void warn_common_ClassloadingUtility_6(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12220 can''t initialize from string {0}", arg0);
	}

	public void warn_objectstore_CacheStore_1(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12221 Commit state failed for {0} and {1}", arg0, arg1);
	}

	public void warn_objectstore_CacheStore_2(Uid arg0, String arg1, String arg2) {
		logger.logv(WARN, "ARJUNA-12222 Remove state failed for {0} and {1} and {2}", arg0, arg1, arg2);
	}

	public void warn_objectstore_CacheStore_3(Uid arg0, String arg1, String arg2, String arg3) {
		logger.logv(WARN, "ARJUNA-12223 Write state failed for {0} and {1} and {2} and {3}", arg0, arg1, arg2, arg3);
	}

	public void warn_objectstore_CacheStore_4(String arg0) {
		logger.logv(WARN, "ARJUNA-12224 Unknown work type {0}", arg0);
	}

	public String get_objectstore_FileSystemStore_1(String arg0) {
		return MessageFormat.format("ARJUNA-12225 FileSystemStore::setupStore - cannot access root of object store: {0}", arg0);
	}

	public void warn_objectstore_FileSystemStore_2(String arg0) {
		logger.logv(WARN, "ARJUNA-12226 FileSystemStore.removeFromCache - no entry for {0}", arg0);
	}

	public void warn_objectstore_FileSystemStore_20(String arg0) {
		logger.logv(WARN, "ARJUNA-12227 FileSystemStore.renameFromTo - from {0} not present. Possibly renamed by crash recovery.", arg0);
	}

	public String get_objectstore_FileSystemStore_2a() {
		return "ARJUNA-12228 FileSystemStore::allObjUids - could not pack Uid.";
	}

	public String get_objectstore_FileSystemStore_3() {
		return "ARJUNA-12229 FileSystemStore::allObjUids - could not pack end of list Uid.";
	}

	public String get_objectstore_FileSystemStore_4() {
		return "ARJUNA-12230 FileSytemStore::allTypes - could not pack entry string.";
	}

	public String get_objectstore_FileSystemStore_5() {
		return "ARJUNA-12231 FileSystemStore::allTypes - could not pack end of list string.";
	}

	public String get_objectstore_FileSystemStore_6() {
		return "ARJUNA-12232 FileSystemStore::setupStore - error from unpack object store.";
	}

	public String get_objectstore_FileSystemStore_7() {
		return "ARJUNA-12233 FileSystemStore::allTypes - could not pack entry string.";
	}

	public String get_objectstore_FileSystemStore_8() {
		return "ARJUNA-12234 FileSystemStore::createHierarchy - null directory name.";
	}

	public void warn_objectstore_HashedStore_2(String arg0) {
		logger.logv(WARN, "ARJUNA-12236 invalid number of hash directories: {0}. Will use default.", arg0);
	}

	public String get_objectstore_HashedStore_5() {
		return "ARJUNA-12237 HashedStore.allObjUids - could not pack Uid.";
	}

	public String get_objectstore_HashedStore_6() {
		return "ARJUNA-12238 HashedStore.allObjUids - could not pack end of list Uid.";
	}

	public void warn_objectstore_JDBCImple_1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12239 hide_state caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_10(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12240 remove_state - type() operation of object with uid {0} returns NULL", arg0);
	}

	public void warn_objectstore_JDBCImple_11(String arg0) {
		logger.logv(WARN, "ARJUNA-12241 invalid initial pool size: {0}", arg0);
	}

	public void warn_objectstore_JDBCImple_12(String arg0) {
		logger.logv(WARN, "ARJUNA-12242 invalid maximum pool size: {0}", arg0);
	}

	public void warn_objectstore_JDBCImple_13(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12243 initialise caught exceptionatorLoader_3", (Object)null);
	}

	public void warn_objectstore_JDBCImple_14(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12244 getState caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_15(String arg0) {
		logger.logv(WARN, "ARJUNA-12245 removeFromCache - no entry for {0}", arg0);
	}

	public void warn_objectstore_JDBCImple_16(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12246 getPool caught exception", (Object)null);
	}

	public void info_objectstore_JDBCImple_17() {
		logger.logv(INFO, "ARJUNA-12247 getPool - interrupted while waiting for a free connection", (Object)null);
	}

	public void warn_objectstore_JDBCImple_18() {
		logger.logv(WARN, "ARJUNA-12248 freePool - freeing a connection which is already free!", (Object)null);
	}

	public void warn_objectstore_JDBCImple_2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12249 reveal_state caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12250 currentState caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_4(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12251 allObjUids caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_5(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12252 allObjUids - pack of Uid failed", (Object)null);
	}

	public void warn_objectstore_JDBCImple_6(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12253 allTypes caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_7(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12254 allTypes - pack of Uid failed", (Object)null);
	}

	public void warn_objectstore_JDBCImple_8(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12255 remove_state caught exception", (Object)null);
	}

	public void warn_objectstore_JDBCImple_9(String arg0, Uid arg1) {
		logger.logv(WARN, "ARJUNA-12256 remove_state() attempted removal of {0} state for object with uid {1}", arg0, arg1);
	}

	public void warn_objectstore_JDBCImple_readfailed() {
		logger.logv(WARN, "ARJUNA-12257 JDBCImple:read_state failed", (Object)null);
	}

	public void warn_objectstore_JDBCImple_writefailed(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12258 JDBCImple:write_state caught exception", (Object)null);
	}

	public void fatal_objectstore_JDBCStore_1(String arg0, String arg1) {
		logger.logv(FATAL, "ARJUNA-12259 JDBCStore could not setup store < {0} , {1} >", arg0, arg1);
	}

	public void fatal_objectstore_JDBCStore_2(String arg0, Throwable arg1) {
		logger.logv(FATAL, arg1, "ARJUNA-12260 Received exception for {0}", arg0);
	}

	public void warn_objectstore_JDBCStore_3() {
		logger.logv(WARN, "ARJUNA-12261 JDBCStore.setupStore failed to initialise!", (Object)null);
	}

	public String get_objectstore_JDBCStore_5() {
		return "ARJUNA-12263 No JDBCAccess implementation provided!";
	}

	public void warn_objectstore_ShadowingStore_1() {
		logger.logv(WARN, "ARJUNA-12264 ShadowingStore.commit_state - store invalid!", (Object)null);
	}

	public void warn_objectstore_ShadowingStore_10(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12265 ShadowingStore::remove_state() - state {0} does not exist for type {1}", arg0, arg1);
	}

	public void warn_objectstore_ShadowingStore_11(String arg0) {
		logger.logv(WARN, "ARJUNA-12266 ShadowingStore::remove_state() - unlink failed on {0}", arg0);
	}

	public void warn_objectstore_ShadowingStore_12(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12267 ShadowingStore.remove_state() - fd error for {0}", arg0);
	}

	public void info_objectstore_ShadowingStore_14(Uid arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-12269 UNKNOWN state for object with uid {0} , type {1}", arg0, arg1);
	}

	public void info_objectstore_ShadowingStore_15(Uid arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-12270 HIDDEN state for object with uid {0} , type {1}", arg0, arg1);
	}

	public void warn_objectstore_ShadowingStore_17(Uid arg0) {
		logger.logv(WARN, "ARJUNA-12272 ShadowingStore.remove_state - type() operation of object with uid {0} returns NULL", arg0);
	}

	public void warn_objectstore_ShadowingStore_18(String arg0) {
		logger.logv(WARN, "ARJUNA-12273 ShadowingStore::write_state() - openAndLock failed for {0}", arg0);
	}

	public void warn_objectstore_ShadowingStore_19(String arg0) {
		logger.logv(WARN, "ARJUNA-12274 ShadowingStore::write_state - unlock or close of {0} failed.", arg0);
	}

	public void warn_objectstore_ShadowingStore_2(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12275 ShadowStore::commit_state - failed to rename {0} to {1}", arg0, arg1);
	}

	public void warn_objectstore_ShadowingStore_3(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12278 ShadowStore::hide_state - failed to rename {0} to {1}", arg0, arg1);
	}

	public void warn_objectstore_ShadowingStore_4(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12279 ShadowStore::reveal_state - failed to rename {0} to {1}", arg0, arg1);
	}

	public void warn_objectstore_ShadowingStore_6() {
		logger.logv(WARN, "ARJUNA-12281 ShadowingStore.read_state - store invalid!", (Object)null);
	}

	public void warn_objectstore_ShadowingStore_7() {
		logger.logv(WARN, "ARJUNA-12282 ShadowingStore::read_state() failed", (Object)null);
	}

	public void warn_objectstore_ShadowingStore_8(String arg0) {
		logger.logv(WARN, "ARJUNA-12283 ShadowingStore::read_state - unlock or close of {0} failed", arg0);
	}

	public void warn_objectstore_ShadowingStore_9(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12284 ShadowingStore::remove_state() - access problems on {0} and {1}", arg0, arg1);
	}

	public void warn_objectstore_jdbc_oracle_1() {
		logger.logv(WARN, "ARJUNA-12285 oracle:read_state failed", (Object)null);
	}

	public void warn_objectstore_jdbc_oracle_2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12286 oracle:write_state caught exception", (Object)null);
	}

	public String get_objectstore_notypenameuid() {
		return "ARJUNA-12287 No typename for object:";
	}

	public String get_objectstore_packProblem() {
		return "ARJUNA-12288 allTypes - could not pack end of list string.";
	}

	public void warn_recovery_AtomicActionRecoveryModule_1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12289 RecoveryManagerStatusModule: Object store exception", (Object)null);
	}

	public void warn_recovery_AtomicActionRecoveryModule_2(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12290 failed to recover Transaction {0}", arg0);
	}

	public void warn_recovery_AtomicActionRecoveryModule_3(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12291 failed to access transaction store {0}", arg0);
	}

	public void warn_recovery_Connection_1() {
		logger.logv(WARN, "ARJUNA-12292 Connection - IOException", (Object)null);
	}

	public void warn_recovery_Connection_2() {
		logger.logv(WARN, "ARJUNA-12293 Setting timeout exception.", (Object)null);
	}

	public void warn_recovery_ExpiredEntryMonitor_10(String arg0) {
		logger.logv(WARN, "ARJUNA-12294 Loading expiry scanner: could not find class {0}", arg0);
	}

	public void info_recovery_ExpiredEntryMonitor_12(String arg0) {
		logger.logv(INFO, "ARJUNA-12296 ExpiredEntryMonitor running at {0}", arg0);
	}

	public void info_recovery_ExpiredEntryMonitor_5() {
		logger.logv(INFO, "ARJUNA-12297 ExpiredEntryMonitor - no scans on first iteration", (Object)null);
	}

	public void warn_recovery_ExpiredEntryMonitor_7() {
		logger.logv(WARN, "ARJUNA-12298 Attempt to load expiry scanner with null class name!", (Object)null);
	}

	public void warn_recovery_ExpiredEntryMonitor_9(String arg0) {
		logger.logv(WARN, "ARJUNA-12299 Expiry scanner {0} does not conform to ExpiryScanner interface", arg0);
	}

	public void warn_recovery_ExpiredTransactionScanner_2(Uid arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-12301 ExpiredTransactionScanner - exception during attempted move {0}", arg0);
	}

	public void info_recovery_ExpiredTransactionScanner_4(Uid arg0) {
		logger.logv(INFO, "ARJUNA-12303 ExpiredTransactionScanner - log {0} is assumed complete and will be moved.", arg0);
	}

	public void info_recovery_ExpiredTransactionStatusManagerScanner_3(Uid arg0) {
		logger.logv(INFO, "ARJUNA-12304 Removing old transaction status manager item {0}", arg0);
	}

	public void warn_recovery_PeriodicRecovery_1() {
		logger.logv(WARN, "ARJUNA-12306 Attempt to load recovery module with null class name!", (Object)null);
	}

	public void info_recovery_PeriodicRecovery_13(String arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-12310 Recovery manager listening on endpoint {0}:{1}", arg0, arg1);
	}

	public void warn_recovery_PeriodicRecovery_2(String arg0) {
		logger.logv(WARN, "ARJUNA-12311 Recovery module {0} does not conform to RecoveryModule interface", arg0);
	}

	public void warn_recovery_PeriodicRecovery_3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12312 Loading recovery module", (Object)null);
	}

	public void warn_recovery_PeriodicRecovery_4(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12313 Loading recovery module", (Object)null);
	}

	public void warn_recovery_PeriodicRecovery_5(String arg0) {
		logger.logv(WARN, "ARJUNA-12314 Loading recovery module: could not find class {0}", arg0);
	}

	public void warn_recovery_PeriodicRecovery_9(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12318 Could not create recovery listener", (Object)null);
	}

	public void warn_recovery_RecActivatorLoader_1() {
		logger.logv(WARN, "ARJUNA-12319 Attempt to load recovery activator with null class name!", (Object)null);
	}

	public void warn_recovery_RecActivatorLoader_2(String arg0) {
		logger.logv(WARN, "ARJUNA-12320 Recovery module {0} does not conform to RecoveryActivator interface", arg0);
	}

	public void warn_recovery_RecActivatorLoader_3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12321 Loading recovery activator", (Object)null);
	}

	public void warn_recovery_RecActivatorLoader_4(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12322 Loading recovery activator", (Object)null);
	}

	public void warn_recovery_RecActivatorLoader_5(String arg0) {
		logger.logv(WARN, "ARJUNA-12323 Loading recovery module: could not find class {0}", arg0);
	}

	public void info_recovery_RecActivatorLoader_6() {
		logger.logv(INFO, "ARJUNA-12324 Start RecoveryActivators", (Object)null);
	}

	public void warn_recovery_RecoveryManagerImple_2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12326 socket I/O exception", (Object)null);
	}

	public void warn_recovery_TransactionStatusConnector_1() {
		logger.logv(WARN, "ARJUNA-12327 TransactionStatusConnector.delete called erroneously", (Object)null);
	}

	public void warn_recovery_TransactionStatusConnector_2() {
		logger.logv(WARN, "ARJUNA-12328 Connection lost to TransactionStatusManagers' process", (Object)null);
	}

	public void warn_recovery_TransactionStatusConnector_3() {
		logger.logv(WARN, "ARJUNA-12329 Connection lost to TransactionStatusManagers' process", (Object)null);
	}

	public void info_recovery_TransactionStatusConnector_4(String arg0, String arg1, String arg2, String arg3) {
		logger.logv(INFO, "ARJUNA-12330 TransactionStatusManager process for uid {0} is ALIVE. connected to host: {1}, port: {2} on socket: {3}", arg0, arg1, arg2, arg3);
	}

	public void info_recovery_TransactionStatusConnector_5(String arg0) {
		logger.logv(INFO, "ARJUNA-12331 TransactionStatusManager process for uid {0} is DEAD.", arg0);
	}

	public void info_recovery_TransactionStatusConnector_6() {
		logger.logv(INFO, "ARJUNA-12332 Failed to establish connection to server", (Object)null);
	}

	public void warn_recovery_TransactionStatusManagerItem_1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12333 Problem with removing host/port item", (Object)null);
	}

	public void warn_recovery_TransactionStatusManagerItem_2(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12334 Problem with storing host/port", (Object)null);
	}

	public void warn_recovery_TransactionStatusManagerItem_3(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12335 Problem retrieving host/port", (Object)null);
	}

	public void warn_recovery_TransactionStatusManagerItem_4(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12336 Failed to obtain host", (Object)null);
	}

	public void info_recovery_TransactionStatusManagerItem_5(String arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-12337 TransactionStatusManagerItem host: {0} port: {1}", arg0, arg1);
	}

	public void warn_recovery_WorkerService_1(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12338 Other Exception:", (Object)null);
	}

	public void warn_recovery_WorkerService_2() {
		logger.logv(WARN, "ARJUNA-12339 IOException", (Object)null);
	}

	public void info_recovery_WorkerService_3() {
		logger.logv(INFO, "ARJUNA-12340 RecoveryManager scan scheduled to begin.", (Object)null);
	}

	public void info_recovery_WorkerService_4() {
		logger.logv(INFO, "ARJUNA-12341 RecoveryManager scan completed.", (Object)null);
	}

	public void fatal_recovery_fail(String arg0, String arg1) {
		logger.logv(FATAL, "ARJUNA-12342 RecoveryManagerImple: cannot bind to socket on address {0} and port {1}", arg0, arg1);
	}

	public void info_recovery_localready() {
		logger.logv(INFO, "ARJUNA-12343 RecoveryManagerImple is ready. Socket listener is turned off.", (Object)null);
	}

	public void info_recovery_socketready(String arg0) {
		logger.logv(INFO, "ARJUNA-12344 RecoveryManagerImple is ready on port {0}", arg0);
	}

	public void warn_tools_log_eaa1(Uid arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-12345 Transaction {0} and {1} not activate.", arg0, arg1);
	}

	public void warn_tools_log_eaa2() {
		logger.logv(WARN, "ARJUNA-12346 Error - could not get resource to forget heuristic. Left on Heuristic List.", (Object)null);
	}

	public String get_utils_ExecProcessId_1() {
		return "ARJUNA-12347 Could not get back a valid pid.";
	}

	public String get_utils_ExecProcessId_2() {
		return "ARJUNA-12348 Problem executing getpids utility:";
	}

	public String get_utils_ExecProcessId_3() {
		return "ARJUNA-12349 Problem executing command:";
	}

	public String get_utils_ExecProcessId_4() {
		return "ARJUNA-12350 Problem getting pid information from stream:";
	}

	public void warn_utils_ExecProcessId_5(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12351 Encountered a problem when closing the data stream", (Object)null);
	}

	public String get_utils_FileProcessId_1() {
		return "ARJUNA-12352 FileProcessId.getpid - could not locate temporary directory.";
	}

	public String get_utils_FileProcessId_2() {
		return "ARJUNA-12353 FileProcessId.getpid could not create unique file.";
	}

	public String get_utils_MBeanProcessId_1() {
		return "ARJUNA-12354 Could not get back a valid pid.";
	}

	public String get_utils_MBeanProcessId_2() {
		return "ARJUNA-12355 getName returned unrecognized format:";
	}

	public String get_utils_ManualProcessId_1() {
		return "ARJUNA-12356 Could not get back a valid pid.";
	}

	public String get_utils_SocketProcessId_2() {
		return "ARJUNA-12359 SocketProcessId.getpid could not get unique port.";
	}

	public void warn_recovery_ExpiredEntryMonitor_6(Throwable arg0) {
		logger.logv(WARN, arg0, "ARJUNA-12360 Unable to instantiate ExpiryScanner", (Object)null);
	}

	public void info_osb_MBeanCtorFail(Throwable arg0) {
		logger.logv(INFO, arg0, "ARJUNA-12361 Error constructing mbean", (Object)null);
	}

	public void info_osb_StateManagerWrapperFail(Throwable arg0) {
		logger.logv(INFO, arg0, "ARJUNA-12362 Failed to create StateManagerWrapper", (Object)null);
	}

    public String get_StoreManager_invalidroot(String arg0, String arg1) {
        return MessageFormat.format("Invalid rootName. Expected {0} but was {1}", arg0, arg1);
    }

    public String get_recovery_RecActivatorLoader_initfailed(String arg0) {
        return MessageFormat.format("RecoveryActivator init failed for {0}", arg0);
    }
}
