/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.resources.spi.XATerminatorExtensions;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.exceptions.UnexpectedConditionException;
import java.io.IOException;
import java.util.Stack;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XATerminatorImple
implements XATerminator,
XATerminatorExtensions {
    private boolean _recoveryStarted = false;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx == null) {
                throw new XAException(-5);
            }
            if (tx.activated()) {
                if (onePhase) {
                    tx.doOnePhaseCommit();
                } else {
                    tx.doCommit();
                }
            } else {
                throw new XAException(4);
            }
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
        catch (RollbackException e) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(100);
            xaException.initCause(e);
            throw xaException;
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            XAException xaException = new XAException(6);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicMixedException ex) {
            XAException xaException = new XAException(5);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicCommitException ex) {
            XAException xaException = new XAException(7);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (IllegalStateException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-4);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (SystemException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx == null) {
                throw new XAException(-5);
            }
            tx.doForget();
        }
        catch (Exception ex) {
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
        finally {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        SubordinateTransaction tx = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
        if (tx == null) {
            throw new XAException(-5);
        }
        switch (tx.doPrepare()) {
            case 2: {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                return 3;
            }
            case 1: {
                Throwable initCause = null;
                int xaExceptionCode = 100;
                try {
                    tx.doRollback();
                }
                catch (HeuristicCommitException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (HeuristicMixedException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (SystemException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (HeuristicRollbackException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                XAException xaException = new XAException(xaExceptionCode);
                if (initCause != null) {
                    xaException.initCause(initCause);
                }
                throw xaException;
            }
            case 0: {
                return 0;
            }
            case 11: {
                throw new XAException(-4);
            }
        }
        throw new XAException(104);
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] indoubt;
        block15: {
            switch (flag) {
                case 0x1000000: {
                    if (this._recoveryStarted) {
                        throw new XAException(-6);
                    }
                    this._recoveryStarted = true;
                    break;
                }
                case 0x800000: {
                    if (!this._recoveryStarted) {
                        throw new XAException(-6);
                    }
                    this._recoveryStarted = false;
                    return null;
                }
                case 0: {
                    if (this._recoveryStarted) break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            indoubt = null;
            try {
                SubordinateTransaction tx;
                RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
                InputObjectState states = new InputObjectState();
                if (!recoveryStore.allObjUids(SubordinateAtomicAction.getType(), states) || !states.notempty()) break block15;
                Stack<SubordinateTransaction> values = new Stack<SubordinateTransaction>();
                boolean finished = false;
                do {
                    Uid uid = null;
                    try {
                        uid = UidHelper.unpackFrom(states);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        finished = true;
                    }
                    if (uid.notEquals(Uid.nullUid())) {
                        tx = SubordinationManager.getTransactionImporter().recoverTransaction(uid);
                        if (tx == null) continue;
                        values.push(tx);
                        continue;
                    }
                    finished = true;
                } while (!finished);
                if (values.size() > 0) {
                    int index = 0;
                    indoubt = new Xid[values.size()];
                    while (!values.empty()) {
                        tx = (TransactionImple)values.pop();
                        indoubt[index] = ((TransactionImple)tx).baseXid();
                        ++index;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return indoubt;
    }

    public void rollback(Xid xid) throws XAException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx == null) {
                throw new XAException(-5);
            }
            if (!tx.activated()) {
                throw new XAException(4);
            }
            tx.doRollback();
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            XAException xaException = new XAException(6);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicCommitException ex) {
            XAException xaException = new XAException(7);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicMixedException ex) {
            XAException xaException = new XAException(5);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (IllegalStateException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-4);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (SystemException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            throw new XAException(-3);
        }
    }

    @Override
    public boolean beforeCompletion(Xid xid) throws SystemException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx == null) {
                throw new UnexpectedConditionException();
            }
            return tx.doBeforeCompletion();
        }
        catch (Exception ex) {
            UnexpectedConditionException e = new UnexpectedConditionException();
            e.initCause(ex);
            throw e;
        }
    }
}

