/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.xa;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.xa.XID;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.UnsupportedEncodingException;
import javax.transaction.xa.Xid;

public class XATxConverter {
    public static final int FORMAT_ID = 131076;

    static XID getXid(Uid uid, boolean branch) throws IllegalStateException {
        if (branch) {
            return XATxConverter.getXid(uid, new Uid(), 131076, null);
        }
        return XATxConverter.getXid(uid, Uid.nullUid(), 131076, null);
    }

    public static Xid getXid(Uid uid, boolean branch, int formatId) throws IllegalStateException {
        XID xid = branch ? XATxConverter.getXid(uid, new Uid(), formatId, null) : XATxConverter.getXid(uid, Uid.nullUid(), formatId, null);
        return new XidImple(xid);
    }

    private static XID getXid(Uid uid, Uid branch, int formatId, String eisNameString) throws IllegalStateException {
        if (uid == null) {
            throw new IllegalStateException();
        }
        XID xid = new XID();
        xid.formatID = formatId;
        byte[] gtridUid = uid.getBytes();
        if (gtridUid.length > 64) {
            throw new IllegalStateException();
        }
        int spareGtridBytes = 64 - gtridUid.length;
        byte[] nodeName = TxControl.getXANodeName();
        int nodeNameLengthToUse = nodeName.length;
        if (nodeName.length > spareGtridBytes) {
            nodeNameLengthToUse = spareGtridBytes;
        }
        xid.gtrid_length = gtridUid.length + nodeNameLengthToUse;
        System.arraycopy(gtridUid, 0, xid.data, 0, gtridUid.length);
        System.arraycopy(nodeName, 0, xid.data, gtridUid.length, nodeNameLengthToUse);
        if (branch.notEquals(Uid.nullUid())) {
            byte[] eisName;
            byte[] bqualUid = branch.getBytes();
            if (bqualUid.length > 64) {
                throw new IllegalStateException();
            }
            int spareBqualBytes = 64 - bqualUid.length;
            try {
                eisName = eisNameString == null ? new byte[]{} : eisNameString.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                eisName = new byte[]{};
            }
            int eisNameLengthToUse = eisName.length;
            if (eisName.length > spareBqualBytes) {
                eisNameLengthToUse = spareBqualBytes;
            }
            xid.bqual_length = bqualUid.length + eisNameLengthToUse;
            System.arraycopy(bqualUid, 0, xid.data, xid.gtrid_length, bqualUid.length);
            System.arraycopy(eisName, 0, xid.data, xid.gtrid_length + bqualUid.length, eisNameLengthToUse);
        } else {
            xid.data[xid.gtrid_length] = 0;
            xid.bqual_length = 64;
        }
        return xid;
    }

    public static Uid getUid(XID xid) {
        if (xid == null || xid.formatID != 131076) {
            return Uid.nullUid();
        }
        Uid tx = new Uid(xid.data);
        return tx;
    }

    public static String getNodeName(XID xid) {
        Uid uid = XATxConverter.getUid(xid);
        int uidLength = uid.getBytes().length;
        int nameLength = xid.gtrid_length - uidLength;
        byte[] nodeName = new byte[nameLength];
        System.arraycopy(xid.data, uidLength, nodeName, 0, nodeName.length);
        try {
            return new String(nodeName, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return "<failed to get nodename>";
        }
    }

    private static Uid getBranchUid(XID xid) {
        if (xid == null || xid.formatID != 131076) {
            return Uid.nullUid();
        }
        byte[] bqual = new byte[xid.bqual_length];
        System.arraycopy(xid.data, xid.gtrid_length, bqual, 0, xid.bqual_length);
        Uid tx = new Uid(bqual);
        return tx;
    }

    private static String getEISName(XID xid) {
        return "unknown eis name";
    }

    public static String getXIDString(XID xid) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("< formatId=");
        stringBuilder.append(xid.formatID);
        stringBuilder.append(", gtrid_length=");
        stringBuilder.append(xid.gtrid_length);
        stringBuilder.append(", bqual_length=");
        stringBuilder.append(xid.bqual_length);
        stringBuilder.append(", tx_uid=");
        stringBuilder.append(XATxConverter.getUid(xid).stringForm());
        stringBuilder.append(", node_name=");
        stringBuilder.append(XATxConverter.getNodeName(xid));
        stringBuilder.append(", branch_uid=");
        stringBuilder.append(XATxConverter.getBranchUid(xid));
        stringBuilder.append(", eis_name=");
        stringBuilder.append(XATxConverter.getEISName(xid));
        stringBuilder.append(" >");
        return stringBuilder.toString();
    }
}

