/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.internal.jta.resources.jts.orbspecific.JTAInterposedSynchronizationImple;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.exceptions.RollbackException;
import java.io.Serializable;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImple
implements TransactionSynchronizationRegistry,
Serializable {
    private static final long serialVersionUID = 1L;

    public Object getTransactionKey() {
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.getTransactionKey");
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        TransactionImple transactionImple = null;
        try {
            transactionImple = (TransactionImple)tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.systemexception"), e);
        }
        if (transactionImple == null) {
            return null;
        }
        return transactionImple.get_uid();
    }

    public void putResource(Object key, Object value) {
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.putResource");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImple transactionImple = this.getTransactionImple();
        transactionImple.putTxLocalResource(key, value);
    }

    public Object getResource(Object key) {
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.getResource");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImple transactionImple = this.getTransactionImple();
        return transactionImple.getTxLocalResource(key);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.registerInterposedSynchronization");
        }
        TransactionImple transactionImple = this.getTransactionImple();
        try {
            transactionImple.registerSynchronizationImple(new JTAInterposedSynchronizationImple(synchronization));
        }
        catch (javax.transaction.RollbackException e) {
            throw new RollbackException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.syncrollbackexception"), e);
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.systemexception"), e);
        }
    }

    public int getTransactionStatus() {
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.getTransactionStatus");
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        try {
            return tm.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.systemexception"), e);
        }
    }

    public void setRollbackOnly() {
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.setRollbackOnly");
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        try {
            Transaction transaction = tm.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException();
            }
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.systemexception"), e);
        }
    }

    public boolean getRollbackOnly() {
        TransactionImple transactionImple;
        if (jtaxLogger.logger.isDebugEnabled()) {
            jtaxLogger.logger.debug("TransactionSynchronizationRegistryImple.getRollbackOnly");
        }
        if ((transactionImple = this.getTransactionImple()) == null) {
            throw new IllegalStateException();
        }
        try {
            return transactionImple.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.systemexception"), e);
        }
    }

    private TransactionImple getTransactionImple() throws IllegalStateException {
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        TransactionImple transactionImple = null;
        try {
            transactionImple = (TransactionImple)tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.systemexception"), e);
        }
        if (transactionImple == null) {
            throw new IllegalStateException();
        }
        return transactionImple;
    }
}

