/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryActivator;
import java.util.Enumeration;
import java.util.Vector;

public class RecActivatorLoader {
    private static Vector _recoveryActivators = null;

    public RecActivatorLoader() {
        this.initialise();
        RecActivatorLoader.loadRecoveryActivators();
        this.startRecoveryActivators();
    }

    public void startRecoveryActivators() {
        tsLogger.i18NLogger.info_recovery_RecActivatorLoader_6();
        Enumeration activators = _recoveryActivators.elements();
        while (activators.hasMoreElements()) {
            RecoveryActivator acti = (RecoveryActivator)activators.nextElement();
            acti.startRCservice();
        }
    }

    private static void loadRecoveryActivators() {
        Vector<String> activatorNames = new Vector<String>(recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryActivators());
        for (String activatorName : activatorNames) {
            RecActivatorLoader.loadActivator(activatorName);
        }
    }

    private static void loadActivator(String className) {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("Loading recovery activator " + className));
        }
        if (className == null) {
            tsLogger.i18NLogger.warn_recovery_RecActivatorLoader_1();
            return;
        }
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            try {
                RecoveryActivator ra = (RecoveryActivator)c.newInstance();
                _recoveryActivators.add(ra);
            }
            catch (ClassCastException e) {
                tsLogger.i18NLogger.warn_recovery_RecActivatorLoader_2(className);
            }
            catch (IllegalAccessException iae) {
                tsLogger.i18NLogger.warn_recovery_RecActivatorLoader_3(iae);
            }
            catch (InstantiationException ie) {
                tsLogger.i18NLogger.warn_recovery_RecActivatorLoader_4(ie);
            }
            c = null;
        }
        catch (ClassNotFoundException cnfe) {
            tsLogger.i18NLogger.warn_recovery_RecActivatorLoader_5(className);
        }
    }

    private final void initialise() {
        _recoveryActivators = new Vector();
    }
}

