/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionManager;
import com.arjuna.ats.internal.jdbc.ConnectionSynchronization;
import com.arjuna.ats.internal.jdbc.DirectRecoverableConnection;
import com.arjuna.ats.internal.jdbc.IndirectRecoverableConnection;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ModifierFactory;
import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XAModifier;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public abstract class ConnectionImple {
    private RecoverableXAConnection _recoveryConnection;
    private Object _theModifier;
    private Connection _theConnection;
    private static final int defaultIsolationLevel = 8;
    private static int _currentIsolationLevel = 8;

    public ConnectionImple(String dbName, Properties info) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("ConnectionImple.ConnectionImple ( " + dbName + " )"));
        }
        String user = null;
        String passwd = null;
        String dynamic = null;
        if (info != null) {
            user = info.getProperty("user");
            passwd = info.getProperty("password");
            dynamic = info.getProperty("DYNAMIC_CLASS");
        }
        this._recoveryConnection = dynamic == null || dynamic.equals("") ? new IndirectRecoverableConnection(dbName, user, passwd, this) : new DirectRecoverableConnection(dbName, user, passwd, dynamic, this);
        this._theModifier = null;
        this._theConnection = null;
    }

    public ConnectionImple(String dbName, String user, String passwd) throws SQLException {
        this(dbName, user, passwd, null);
    }

    public ConnectionImple(String dbName, String user, String passwd, String dynamic) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("ConnectionImple.ConnectionImple ( " + dbName + ", " + user + ", " + passwd + ", " + dynamic + " )"));
        }
        this._recoveryConnection = dynamic == null || dynamic.equals("") ? new IndirectRecoverableConnection(dbName, user, passwd, this) : new DirectRecoverableConnection(dbName, user, passwd, dynamic, this);
        this._theModifier = null;
        this._theConnection = null;
    }

    public Statement createStatement() throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().createStatement();
    }

    public Statement createStatement(int rs, int rc) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().createStatement(rs, rc);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int rs, int rc) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, rs, rc);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int rs, int rc) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareCall(sql, rs, rc);
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().nativeSQL(sql);
    }

    public Map getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionRunning()) {
            if (autoCommit) {
                throw new SQLException(jdbcLogger.i18NLogger.get_autocommit());
            }
        } else {
            this.getConnection().setAutoCommit(autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    public void commit() throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_commiterror());
        }
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_aborterror());
        }
        this.getConnection().rollback();
    }

    public void close() throws SQLException {
        try {
            if (!this._recoveryConnection.inuse()) {
                ConnectionManager.remove(this);
            }
            TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
            Transaction tx2 = tm.getTransaction();
            boolean delayClose = false;
            if (tx2 != null) {
                if (this._recoveryConnection.validTransaction(tx2)) {
                    XAResource xares = this._recoveryConnection.getResource();
                    if (!tx2.delistResource(xares, 0x4000000)) {
                        throw new SQLException(jdbcLogger.i18NLogger.get_delisterror());
                    }
                    this.getModifier();
                    if (this._theModifier == null) {
                        jdbcLogger.i18NLogger.info_closingconnectionnull(this._theConnection.toString());
                        if (this._theConnection != null && !this._theConnection.isClosed()) {
                            this._theConnection.close();
                        }
                        this._theConnection = null;
                        return;
                    }
                    if (((ConnectionModifier)this._theModifier).supportsMultipleConnections()) {
                        jdbcLogger.i18NLogger.warn_closingconnection(this._theConnection.toString());
                        delayClose = true;
                    }
                    if (delayClose) {
                        tx2.registerSynchronization((Synchronization)new ConnectionSynchronization(this._theConnection, this._recoveryConnection));
                        this._theConnection = null;
                    }
                } else {
                    throw new SQLException(jdbcLogger.i18NLogger.get_closeerrorinvalidtx(tx2.toString()));
                }
            }
            if (!delayClose) {
                this._recoveryConnection.closeCloseCurrentConnection();
                if (this._theConnection != null && !this._theConnection.isClosed()) {
                    this._theConnection.close();
                }
                this._theConnection = null;
            }
        }
        catch (IllegalStateException ex) {
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e1) {
            SQLException sqlException = new SQLException(jdbcLogger.i18NLogger.get_closeerror());
            sqlException.initCause(e1);
            throw sqlException;
        }
    }

    public boolean isClosed() throws SQLException {
        this.checkTransaction();
        if (this._theConnection == null) {
            return false;
        }
        return this._theConnection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public void setReadOnly(boolean ro) throws SQLException {
        if (this._recoveryConnection.inuse()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_setreadonly());
        }
        this.getConnection().setReadOnly(ro);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    public void setCatalog(String cat) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        this.getConnection().setCatalog(cat);
    }

    public String getCatalog() throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().getCatalog();
    }

    public void setTransactionIsolation(int iso) throws SQLException {
        this.checkTransaction();
        this.getConnection().setTransactionIsolation(iso);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    public final RecoverableXAConnection recoveryConnection() {
        return this._recoveryConnection;
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        this.getConnection().setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_setsavepointerror());
        }
        return this.getConnection().setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_setsavepointerror());
        }
        return this.getConnection().setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_rollbacksavepointerror());
        }
        this.getConnection().rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.i18NLogger.get_releasesavepointerror());
        }
        this.getConnection().releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, columnNames);
    }

    protected final XAResource getXAResource() {
        try {
            return this._recoveryConnection.getResource();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reset() {
        try {
            if (this._theConnection != null) {
                this._theConnection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._theConnection = null;
        }
    }

    final Connection getConnection() throws SQLException {
        if (this._theConnection != null && !this._theConnection.isClosed()) {
            return this._theConnection;
        }
        XAConnection xaConn = this._recoveryConnection.getConnection();
        if (xaConn != null) {
            this._theConnection = xaConn.getConnection();
            try {
                this.getModifier();
                if (this._theModifier != null) {
                    ((ConnectionModifier)this._theModifier).setIsolationLevel(this._theConnection, _currentIsolationLevel);
                }
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception e) {
                jdbcLogger.i18NLogger.warn_isolationlevelfailset("ConnectionImple.getConnection", e);
                SQLException sqlException = new SQLException(jdbcLogger.i18NLogger.get_conniniterror());
                sqlException.initCause(e);
                throw sqlException;
            }
            return this._theConnection;
        }
        return null;
    }

    final ConnectionControl connectionControl() {
        return (ConnectionControl)((Object)this._recoveryConnection);
    }

    protected final boolean transactionRunning() throws SQLException {
        try {
            return com.arjuna.ats.jta.TransactionManager.transactionManager().getTransaction() != null;
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    protected final synchronized void registerDatabase() throws SQLException {
        Connection theConnection;
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"ConnectionImple.registerDatabase ()");
        }
        if ((theConnection = this.getConnection()) != null) {
            XAResource xares = null;
            try {
                TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
                Transaction tx2 = tm.getTransaction();
                if (tx2 == null) {
                    return;
                }
                if (!this._recoveryConnection.setTransaction(tx2)) {
                    throw new SQLException(jdbcLogger.i18NLogger.get_alreadyassociated());
                }
                Object[] params = this._theModifier != null ? new Object[2] : new Object[]{this._recoveryConnection};
                if (this._theModifier != null) {
                    params[1] = (XAModifier)this._theModifier;
                }
                if (!((com.arjuna.ats.jta.transaction.Transaction)tx2).enlistResource(xares = this._recoveryConnection.getResource(), params)) {
                    try {
                        tx2.setRollbackOnly();
                    }
                    catch (Exception e) {
                        jdbcLogger.i18NLogger.warn_rollbackerror("ConnectionImple.registerDatabase");
                        SQLException sqlException = new SQLException(e.toString());
                        sqlException.initCause(e);
                        throw sqlException;
                    }
                    throw new SQLException("ConnectionImple.registerDatabase - " + jdbcLogger.i18NLogger.get_enlistfailed());
                }
                params = null;
                xares = null;
                tx2 = null;
                tm = null;
            }
            catch (RollbackException e1) {
                SQLException sqlException = new SQLException("ConnectionImple.registerDatabase - " + (Object)((Object)e1));
                sqlException.initCause(e1);
                throw sqlException;
            }
            catch (SystemException e2) {
                SQLException sqlException = new SQLException("ConnectionImple.registerDatabase - " + (Object)((Object)e2));
                sqlException.initCause(e2);
                throw sqlException;
            }
            catch (SQLException e3) {
                throw e3;
            }
            catch (Exception e4) {
                SQLException sqlException = new SQLException(e4.toString());
                sqlException.initCause(e4);
                throw sqlException;
            }
        }
    }

    protected final void checkTransaction() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"ConnectionImple.checkTransaction ()");
        }
        try {
            TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
            Transaction tx2 = tm.getTransaction();
            if (tx2 == null) {
                return;
            }
            if (tx2.getStatus() != 0) {
                throw new SQLException(jdbcLogger.i18NLogger.get_inactivetransaction());
            }
            if (!this._recoveryConnection.validTransaction(tx2)) {
                throw new SQLException(jdbcLogger.i18NLogger.get_alreadyassociatedcheck());
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e3) {
            SQLException sqlException = new SQLException(jdbcLogger.i18NLogger.get_infoerror());
            sqlException.initCause(e3);
            throw sqlException;
        }
    }

    private final void getModifier() {
        if (this._theModifier == null) {
            try {
                DatabaseMetaData md = this._theConnection.getMetaData();
                String name = md.getDriverName();
                int major = md.getDriverMajorVersion();
                int minor = md.getDriverMinorVersion();
                this._theModifier = ModifierFactory.getModifier(name, major, minor);
                ((ConnectionControl)((Object)this._recoveryConnection)).setModifier((ConnectionModifier)this._theModifier);
            }
            catch (Exception ex) {
                jdbcLogger.i18NLogger.warn_getmoderror(ex);
            }
        }
    }

    static {
        _currentIsolationLevel = jdbcPropertyManager.getJDBCEnvironmentBean().getIsolationLevel();
    }
}

