/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.jbossts.jopr;

import java.util.Set;
import javax.management.ObjectName;
import org.jboss.as.integration.jbossts.jopr.JMXClient;
import org.jboss.as.integration.jbossts.jopr.TxnConstants;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxnEngineComponent
extends JMXClient {
    private ObjectName coreEnvObjName;
    private ObjectName statsObjName;

    @Override
    public void start(ResourceContext context) {
        super.start(context);
        this.coreEnvObjName = TxnConstants.COREEBEAN;
        this.statsObjName = TxnConstants.STATBEAN;
    }

    @Override
    public AvailabilityType getAvailability() {
        try {
            this.conn.getMBeanInfo(new ObjectName("jboss:service=TransactionManager"));
            return AvailabilityType.UP;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        try {
            super.getValues(report, requests, this.coreEnvObjName);
            super.getValues(report, requests, this.statsObjName);
        }
        catch (Exception e) {
            this.log.info((Object)("TxnEngineComponent lookup error: " + e.getMessage()));
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        try {
            this.updateConfig(config, TxnConstants.CEBEAN, configDef.getPropertiesInGroup("CommonConfiguration"));
            this.updateConfig(config, TxnConstants.COREEBEAN, configDef.getPropertiesInGroup("CommonConfiguration"));
            this.updateConfig(config, TxnConstants.JTAEBEAN, configDef.getPropertiesInGroup("EngineConfiguration"));
            this.updateConfig(config, TxnConstants.JTAEBEAN, configDef.getPropertiesInGroup("EngineConfigurationClasses"));
            this.updateConfig(config, TxnConstants.CEBEAN, configDef.getPropertiesInGroup("CoordinatorConfiguration"));
            this.updateConfig(config, TxnConstants.REBEAN, configDef.getPropertiesInGroup("RecoveryConfiguration"));
            this.updateConfig(config, TxnConstants.COREEBEAN, configDef.getPropertiesInGroup("CoreEngineConfiguration"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return config;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        this.updateResourceConfiguration(report, "CommonConfiguration", TxnConstants.CEBEAN, TxnConstants.COREEBEAN);
        this.updateResourceConfiguration(report, "EngineConfiguration", TxnConstants.JTAEBEAN);
        this.updateResourceConfiguration(report, "EngineConfigurationClasses", TxnConstants.JTAEBEAN);
        this.updateResourceConfiguration(report, "CoordinatorConfiguration", TxnConstants.CEBEAN);
        this.updateResourceConfiguration(report, "RecoveryConfiguration", TxnConstants.REBEAN);
        this.updateResourceConfiguration(report, "CoreEngineConfiguration", TxnConstants.COREEBEAN);
    }
}

