/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.jbossts.jopr;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.jboss.as.integration.jbossts.jopr.JMXClient;
import org.jboss.as.integration.jbossts.jopr.TxnConstants;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxnEntryComponent
extends JMXClient {
    private ObjectName objectName;
    private boolean deleted;

    @Override
    public void start(ResourceContext context) throws InvalidPluginConfigurationException {
        super.start(context);
        try {
            this.objectName = new ObjectName(context.getResourceKey());
        }
        catch (MalformedObjectNameException e) {
            this.log.warn((Object)("Invalid transaction mbean name: " + context.getResourceKey()));
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
    }

    @Override
    public AvailabilityType getAvailability() {
        return this.deleted ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        try {
            this.getValues(report, requests, this.objectName);
        }
        catch (Exception e) {
            this.log.info((Object)("MBean log entry lookup error: " + e.getMessage()));
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        try {
            this.updateConfig(config, TxnConstants.OSENVBEAN, configDef.getPropertiesInGroup("ObjStoreConfiguration"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return config;
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration params) {
        String result = "Unsupported operation or invalid Transaction Store";
        if (name.equals("remove")) {
            try {
                Object res = this.invokeOperation(this.objectName, "remove", new Object[0]);
                result = "operation returned " + res;
                this.deleted = true;
            }
            catch (Exception e) {
                result = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            }
        }
        return new OperationResult(result);
    }

    @Override
    public void deleteResource() throws Exception {
        try {
            if (!this.deleted) {
                this.invokeOperation(this.objectName, "remove", new Object[0]);
                this.deleted = true;
                this.log.debug((Object)("Transaction removed from log store: " + this.objectName));
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Unable to remove transaction from log store: " + e.getMessage()));
            throw new Exception("Unable to remove transaction: " + e.getMessage());
        }
    }

    public Collection<ObjectName> getParticipants() {
        QueryExp query = Query.eq(Query.attr("Participant"), Query.value(true));
        String scope = this.objectName.getCanonicalName() + ",*";
        try {
            return this.conn.queryNames(new ObjectName(scope), query);
        }
        catch (Exception e) {
            this.log.info((Object)("MBean query error: " + e));
            return Collections.EMPTY_SET;
        }
    }
}

