/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.jbossts.jopr;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.integration.jbossts.jopr.JMXClient;
import org.jboss.as.integration.jbossts.jopr.TxnEntryComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxnParticipantComponent
extends JMXClient {
    private ObjectName objectName;
    private TxnEntryComponent txn;

    @Override
    public void start(ResourceContext context) {
        super.start(context);
        this.txn = (TxnEntryComponent)context.getParentResourceComponent();
        try {
            this.objectName = new ObjectName(context.getResourceKey());
        }
        catch (MalformedObjectNameException e) {
            this.log.warn((Object)("Invalid transaction participant mbean name: " + e));
        }
    }

    @Override
    public AvailabilityType getAvailability() {
        return this.txn != null ? this.txn.getAvailability() : AvailabilityType.DOWN;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        if (this.objectName != null) {
            try {
                super.getValues(report, requests, this.objectName);
            }
            catch (Exception e) {
                this.log.warn((Object)("Error retrieving txn participant attributes: " + e));
            }
        }
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        String result = "Unsupported operation or invalid Transaction Store";
        if (name.equals("setStatus") && this.objectName != null) {
            try {
                this.conn.setAttribute(this.objectName, new Attribute("Status", params.getSimpleValue("status", "PREPARED")));
                result = "Operation succeeed";
            }
            catch (Exception e) {
                result = "Operation failed: ";
                result = result + (e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                throw new Exception(result, e);
            }
        }
        return new OperationResult(result);
    }
}

