/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.internal.jta.resources.spi.XATerminatorExtensions;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.utils.JTAHelper;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.inbound.InboundBridge;
import org.jboss.jbossts.txbridge.inbound.InboundBridgeManager;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class BridgeVolatileParticipant
implements Volatile2PCParticipant {
    private final XATerminatorExtensions xaTerminatorExtensions;
    private final String externalTxId;
    private final Xid xid;

    BridgeVolatileParticipant(String externalTxId, Xid xid) {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.<ctor>(TxId=" + externalTxId + ", Xid=" + xid + ")"));
        this.xid = xid;
        this.externalTxId = externalTxId;
        this.xaTerminatorExtensions = (XATerminatorExtensions)SubordinationManager.getXATerminator();
    }

    public Vote prepare() throws WrongStateException, SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.prepare(Xid=" + this.xid + ")"));
        InboundBridge inboundBridge = InboundBridgeManager.getInboundBridge(this.externalTxId);
        try {
            inboundBridge.start();
            if (!this.xaTerminatorExtensions.beforeCompletion(this.xid)) {
                txbridgeLogger.i18NLogger.warn_ibvp_preparefailed(XAHelper.xidToString((Xid)this.xid), null);
                inboundBridge.setRollbackOnly();
            }
            Prepared prepared = new Prepared();
            return prepared;
        }
        catch (Exception e) {
            txbridgeLogger.i18NLogger.warn_ibvp_preparefailed(XAHelper.xidToString((Xid)this.xid), e);
            try {
                inboundBridge.setRollbackOnly();
            }
            catch (Exception e2) {
                txbridgeLogger.i18NLogger.warn_ibvp_setrollbackfailed(e2);
            }
            Prepared prepared = new Prepared();
            return prepared;
        }
        finally {
            try {
                inboundBridge.stop();
            }
            catch (Exception e) {
                txbridgeLogger.i18NLogger.warn_ibvp_stopfailed(XAHelper.xidToString((Xid)this.xid), e);
            }
        }
    }

    public void commit() throws WrongStateException, SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.commit(Xid=" + this.xid + ")"));
        this.afterCompletion(3);
    }

    public void rollback() throws WrongStateException, SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.rollback(Xid=" + this.xid + ")"));
        this.afterCompletion(4);
    }

    private void afterCompletion(int status) {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.afterCompletion(Xid=" + this.xid + ", status=" + status + "/" + JTAHelper.stringForm((int)status) + ")"));
    }

    public void unknown() throws SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.unknown(Xid=" + this.xid + "): NOT IMPLEMENTED"));
    }

    public void error() throws SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeVolatileParticipant.unknown(Xid=" + this.xid + "): NOT IMPLEMENTED"));
    }
}

