/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.utils;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;

public class HttpUtils {
    public static final int GET = 1;
    public static final int POST = 2;
    public static final int HEAD = 3;
    public static final int OPTIONS = 4;
    public static final int PUT = 5;
    public static final int DELETE = 6;
    public static final int TRACE = 7;

    public static HttpMethodBase accessURL(URL url) throws Exception {
        return HttpUtils.accessURL(url, null, 200);
    }

    public static HttpMethodBase accessURL(URL url, String realm, int expectedHttpCode) throws Exception {
        return HttpUtils.accessURL(url, realm, expectedHttpCode, null);
    }

    public static HttpMethodBase accessURL(URL url, String realm, int expectedHttpCode, int type) throws Exception {
        return HttpUtils.accessURL(url, realm, expectedHttpCode, null, type);
    }

    public static HttpMethodBase accessURL(URL url, String realm, int expectedHttpCode, Header[] hdrs) throws Exception {
        return HttpUtils.accessURL(url, realm, expectedHttpCode, hdrs, 1);
    }

    public static HttpMethodBase accessURL(URL url, String realm, int expectedHttpCode, Header[] hdrs, int type) throws Exception {
        HttpClient httpConn = new HttpClient();
        HttpMethodBase request = HttpUtils.createMethod(url, type);
        int hdrCount = hdrs != null ? hdrs.length : 0;
        int n = 0;
        while (n < hdrCount) {
            request.addRequestHeader(hdrs[n]);
            ++n;
        }
        System.err.println("Connecting to: " + url);
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            UsernamePasswordCredentials auth = new UsernamePasswordCredentials(userInfo);
            httpConn.getState().setCredentials(realm, url.getHost(), (Credentials)auth);
        }
        System.err.println("RequestURI: " + request.getURI());
        int responseCode = httpConn.executeMethod((HttpMethod)request);
        String response = request.getStatusText();
        System.err.println("responseCode=" + responseCode + ", response=" + response);
        String content = request.getResponseBodyAsString();
        System.err.println(content);
        if (responseCode != expectedHttpCode) {
            throw new IOException("Expected reply code:" + expectedHttpCode + ", actual=" + responseCode);
        }
        return request;
    }

    public static HttpMethodBase createMethod(URL url, int type) {
        GetMethod request = null;
        switch (type) {
            case 1: {
                request = new GetMethod(url.toString());
                break;
            }
            case 2: {
                request = new PostMethod(url.toString());
                break;
            }
            case 3: {
                request = new HeadMethod(url.toString());
                break;
            }
            case 4: {
                request = new OptionsMethod(url.toString());
                break;
            }
            case 5: {
                request = new PutMethod(url.toString());
                break;
            }
            case 6: {
                request = new DeleteMethod(url.toString());
                break;
            }
            case 7: {
                request = new TraceMethod(url.toString());
            }
        }
        return request;
    }
}

