/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.TransactionStatusManager;

public class TxControl {
    public static final int NODE_NAME_SIZE = 28;
    public static final String DEFAULT_NODE_NAME = "Arjuna:";
    static boolean maintainHeuristics = true;
    static boolean asyncCommit = false;
    static boolean asyncPrepare = false;
    static boolean asyncRollback = false;
    static boolean onePhase = true;
    static boolean readonlyOptimisation = true;
    static volatile boolean enable = true;
    private static TransactionStatusManager transactionStatusManager = null;
    static String xaNodeName = arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier();
    static int _defaultTimeout = 60;
    static boolean _enableTSM = true;
    static boolean beforeCompletionWhenRollbackOnly = false;
    static Thread _shutdownHook = null;
    static Object _lock = new Object();

    static {
        _defaultTimeout = arjPropertyManager.getCoordinatorEnvironmentBean().getDefaultTimeout();
        maintainHeuristics = arjPropertyManager.getCoordinatorEnvironmentBean().isMaintainHeuristics();
        asyncCommit = arjPropertyManager.getCoordinatorEnvironmentBean().isAsyncCommit();
        asyncPrepare = arjPropertyManager.getCoordinatorEnvironmentBean().isAsyncPrepare();
        onePhase = arjPropertyManager.getCoordinatorEnvironmentBean().isCommitOnePhase();
        asyncRollback = arjPropertyManager.getCoordinatorEnvironmentBean().isAsyncRollback();
        readonlyOptimisation = arjPropertyManager.getCoordinatorEnvironmentBean().isReadonlyOptimisation();
        enable = !arjPropertyManager.getCoordinatorEnvironmentBean().isStartDisabled();
        beforeCompletionWhenRollbackOnly = arjPropertyManager.getCoordinatorEnvironmentBean().isBeforeCompletionWhenRollbackOnly();
        _enableTSM = arjPropertyManager.getCoordinatorEnvironmentBean().isTransactionStatusManagerEnable();
        TxControl.createTransactionStatusManager();
    }

    public static final int getDefaultTimeout() {
        return _defaultTimeout;
    }

    public static final void setDefaultTimeout(int timeout) {
        _defaultTimeout = timeout;
    }

    public static final synchronized void enable() {
        TxControl.createTransactionStatusManager();
        enable = true;
    }

    public static final synchronized void disable() {
        TxControl.disable(false);
    }

    public static final synchronized void disable(boolean disableRecovery) {
        if (disableRecovery) {
            TxControl.removeTransactionStatusManager();
        }
        enable = false;
    }

    public static final boolean isEnabled() {
        return enable;
    }

    public static final boolean getAsyncPrepare() {
        return asyncPrepare;
    }

    public static final boolean getMaintainHeuristics() {
        return maintainHeuristics;
    }

    public static boolean isReadonlyOptimisation() {
        return readonlyOptimisation;
    }

    public static final String getXANodeName() {
        return xaNodeName;
    }

    public static void setXANodeName(String name) {
        if (name.getBytes().length > 36) {
            tsLogger.i18NLogger.warn_coordinator_toolong();
            throw new IllegalArgumentException();
        }
        xaNodeName = name;
    }

    public static boolean isBeforeCompletionWhenRollbackOnly() {
        return beforeCompletionWhenRollbackOnly;
    }

    private static final synchronized void createTransactionStatusManager() {
        if (transactionStatusManager == null && _enableTSM) {
            transactionStatusManager = new TransactionStatusManager();
            _shutdownHook = new Shutdown();
            Runtime.getRuntime().addShutdownHook(_shutdownHook);
        }
    }

    private static final synchronized void removeTransactionStatusManager() {
        if (_shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(_shutdownHook);
            _shutdownHook = null;
            if (transactionStatusManager != null) {
                transactionStatusManager.shutdown();
                transactionStatusManager = null;
            }
        }
    }

    public static class Shutdown
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<TxControl> clazz = TxControl.class;
            synchronized (TxControl.class) {
                if (_shutdownHook == this && transactionStatusManager != null) {
                    transactionStatusManager.shutdown();
                    TxControl.transactionStatusManager = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

