/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class RecoveryDriver {
    public static final String SCAN = "SCAN";
    public static final String ASYNC_SCAN = "ASYNC_SCAN";
    public static final String PING = "PING";
    public static final String PONG = "PONG";
    public static final int DEFAULT_SYNC_TIMEOUT = 1000 + recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryBackoffPeriod() * 1000;
    public static final int DEFAULT_SYNC_RETRY = 5;
    public static final int DEFAULT_SO_TIMEOUT = 20000;
    private String _hostName = null;
    private int _port = 0;
    private int _timeout = 20000;

    public RecoveryDriver(int port) {
        this(port, null, 20000);
    }

    public RecoveryDriver(int port, String hostName) {
        this(port, hostName, 20000);
    }

    public RecoveryDriver(int port, String hostName, int timeout) {
        this._port = port;
        this._hostName = hostName;
        this._timeout = timeout;
    }

    public final boolean synchronousScan() throws UnknownHostException, SocketException, IOException {
        return this.synchronousScan(DEFAULT_SYNC_TIMEOUT, 5);
    }

    public final boolean synchronousScan(int timeout, int retry) throws UnknownHostException, SocketException, IOException {
        return this.scan(SCAN, timeout, retry);
    }

    public final boolean asynchronousScan() throws UnknownHostException, SocketException, IOException {
        return this.scan(ASYNC_SCAN, this._timeout, 1);
    }

    private final boolean scan(String scanType, int timeout, int retry) throws UnknownHostException, SocketException, IOException {
        if (this._hostName == null) {
            this._hostName = InetAddress.getLocalHost().getHostName();
        }
        boolean success = false;
        Socket connectorSocket = null;
        int i = 0;
        while (i < retry && !success) {
            block11: {
                connectorSocket = new Socket(this._hostName, this._port);
                connectorSocket.setSoTimeout(timeout);
                try {
                    try {
                        BufferedReader fromServer = new BufferedReader(new InputStreamReader(connectorSocket.getInputStream()));
                        PrintWriter toServer = new PrintWriter(new OutputStreamWriter(connectorSocket.getOutputStream()));
                        toServer.println(scanType);
                        toServer.flush();
                        String response = fromServer.readLine();
                        if (response.equals("DONE")) {
                            success = true;
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        if (connectorSocket != null) {
                            connectorSocket.close();
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (connectorSocket != null) {
                        connectorSocket.close();
                    }
                    throw throwable;
                }
                if (connectorSocket != null) {
                    connectorSocket.close();
                }
            }
            ++i;
        }
        return success;
    }
}

