/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.state;

import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class OutputBuffer {
    protected boolean _valid = true;
    protected static final int headerSize = 8;
    protected static final int ALIGNMENT = 4;
    private DataOutputStream _output;
    private ByteArrayOutputStream _outputStream;
    private static final byte[] _byte = new byte[1];

    public OutputBuffer() {
        try {
            this._outputStream = new ByteArrayOutputStream();
            this._output = new DataOutputStream(this._outputStream);
            this.initBuffer();
        }
        catch (IOException e) {
            this._valid = false;
        }
    }

    public OutputBuffer(int buffSize) {
        try {
            this._outputStream = new ByteArrayOutputStream(buffSize);
            this._output = new DataOutputStream(this._outputStream);
            this.initBuffer();
        }
        catch (IOException e) {
            this._valid = false;
        }
    }

    public OutputBuffer(byte[] b) {
        try {
            this._outputStream = new ByteArrayOutputStream(0);
            this._output = new DataOutputStream(this._outputStream);
            this._outputStream.write(b, 0, b.length);
            this.initBuffer();
        }
        catch (NullPointerException ex) {
            this._valid = false;
        }
        catch (IOException e) {
            this._valid = false;
        }
    }

    public OutputBuffer(OutputBuffer copyFrom) {
        this._outputStream = null;
        this._output = null;
        this.copy(copyFrom);
    }

    public final synchronized boolean valid() {
        return this._valid;
    }

    public final synchronized byte[] buffer() {
        try {
            this._output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._outputStream.toByteArray();
    }

    public final synchronized int length() {
        return this._outputStream.size();
    }

    public synchronized void copy(OutputBuffer b) {
        if (b._valid) {
            this._valid = true;
            try {
                this._outputStream = new ByteArrayOutputStream(b.length());
                this._output = new DataOutputStream(this._outputStream);
                this._outputStream.write(b.buffer(), 0, b.length());
                this.initBuffer();
            }
            catch (IOException e) {
                this._valid = false;
            }
        }
    }

    public final synchronized void reset() throws IOException {
        this._outputStream.reset();
        this.initBuffer();
    }

    public final synchronized void packByte(byte b) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_1());
        }
        this.packInt(b);
    }

    public final synchronized void packBytes(byte[] b) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_2());
        }
        this.packInt(b.length);
        if (b.length > 0) {
            this._output.write(b, 0, b.length);
            this.realign(b.length);
        }
    }

    public final synchronized void packBoolean(boolean b) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_3());
        }
        this._valid = false;
        int i = 0;
        while (i < 3) {
            this._output.write(_byte, 0, 1);
            ++i;
        }
        this._output.writeBoolean(b);
        this._valid = true;
    }

    public final synchronized void packChar(char c) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_4());
        }
        this.packInt(c);
    }

    public final synchronized void packShort(short s) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_5());
        }
        this.packInt(s);
    }

    public final synchronized void packInt(int i) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_6());
        }
        this._valid = false;
        this._output.writeInt(i);
        this._valid = true;
    }

    public final synchronized void packLong(long l) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_7());
        }
        this._valid = false;
        this._output.writeLong(l);
        this._valid = true;
    }

    public final synchronized void packFloat(float f) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_8());
        }
        this._valid = false;
        this._output.writeFloat(f);
        this._valid = true;
    }

    public final synchronized void packDouble(double d) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_9());
        }
        this._valid = false;
        this._output.writeDouble(d);
        this._valid = true;
    }

    public final synchronized void packString(String s) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_10());
        }
        int sz = 0;
        String dummy = null;
        if (s != null) {
            sz = s.length() + 1;
            dummy = String.valueOf(s) + '\u0000';
        }
        this.packInt(sz);
        this._valid = false;
        if (sz > 0) {
            byte[] bytes = dummy.getBytes();
            this._output.write(bytes, 0, bytes.length);
            this.realign(bytes.length);
        }
        this._valid = true;
    }

    public synchronized void packInto(OutputBuffer buff) throws IOException {
        if (buff == null) {
            throw new IOException(tsLogger.i18NLogger.get_state_OutputBuffer_11());
        }
        if (this._valid) {
            buff.packBytes(this.buffer());
        }
    }

    public void print(PrintWriter strm) {
        if (this._valid) {
            strm.println("OutputBuffer : \n");
            byte[] b = this.buffer();
            int i = 0;
            while (i < b.length) {
                strm.write((char)b[i]);
                ++i;
            }
        } else {
            strm.println("OutputBuffer : invalid.");
        }
    }

    public final boolean rewrite() {
        if (!this._valid) {
            return false;
        }
        try {
            this._outputStream = new ByteArrayOutputStream();
            this._output = new DataOutputStream(this._outputStream);
            this.initBuffer();
        }
        catch (IOException e) {
            this._valid = false;
        }
        return this._valid;
    }

    private final void realign(int amount) throws IOException {
        if (amount % 4 > 0) {
            int excess = 4 - amount % 4;
            int i = 0;
            while (i < excess) {
                this._output.write(_byte, 0, 1);
                ++i;
            }
        }
    }

    private final void initBuffer() throws IOException {
        String version = "#BE";
        this._output.writeBytes(version);
        this._output.writeBoolean(true);
        this._output.writeByte(16);
        this._output.writeByte(32);
        this._output.writeByte(64);
        this._output.writeByte(0);
    }
}

