/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.stats;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBeanMBean;
import com.arjuna.ats.arjuna.coordinator.TxStatsMBean;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.beans.AxisScale;
import org.jfree.beans.JLineChart;
import org.jfree.beans.JPieChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxPerfGraph
extends JPanel {
    private static final int NUMBER_OF_SAMPLES = 100;
    private int POLL_PERIOD = 4000;
    public static final int NUMBER_OF_TRANSACTIONS_SERIES = 0;
    public static final int NUMBER_OF_INFLIGHT_SERIES = 1;
    public static final int NUMBER_OF_COMMITTED_SERIES = 2;
    public static final int NUMBER_OF_ABORTED_SERIES = 3;
    public static final int NUMBER_OF_HEURISTICS_SERIES = 4;
    public static final int NUMBER_OF_NESTED_SERIES = 5;
    public static final int NUMBER_OF_TIMEDOUT_SERIES = 6;
    private static final String[] SERIES_LABELS = new String[]{"Transactions Created", "In Flight Transactions", "Committed Transactions", "Aborted Transactions", "Heuristics Raised", "Nested Transactions Created", "Timed Out Transactions"};
    private static final String[] PIE_CHART_LABELS = new String[]{"Nested", "Heuristic", "Committed", "Aborted"};
    private static final int[] PIE_CHART_SERIES = new int[]{5, 4, 2, 3};
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    private MBeanServerConnection server;
    private JFrame frame;
    private TxStatsMBean txMBean;
    private CoordinatorEnvironmentBeanMBean coordMBean;
    private XYSeries[] _dataSeries = new XYSeries[7];
    private XYSeriesCollection[] _tsDS = new XYSeriesCollection[7];
    private long counter = 0L;
    private DefaultPieDataset pieDS;
    Timer swingTimer;
    ActionListener taskPerformer;
    private JRadioButton abortedTxnBtn;
    private JRadioButton allTxnBtn;
    private JPanel btnPanel;
    private JLineChart chart1;
    private JTabbedPane chartsPane;
    private JRadioButton committedTxnBtn;
    private ButtonGroup configBtnGroup;
    private JPanel configTab;
    private JCheckBox enableStatsCB;
    private JRadioButton heuristicTxnBtn;
    private JRadioButton inFlightTxnBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JMenuBar menuBar;
    private JRadioButton nestedTxnBtn;
    private JPanel periodSelectPanel;
    private JSlider periodSelectSlider;
    private JButton pollIntervalBtn;
    private JSpinner pollIntervalSpinner;
    private JButton resetStatsBtn;
    private JButton sampleSizeBtn1;
    private JSpinner sampleSizeSpinner;
    private ButtonGroup seriesSelectBtnGroup;
    private JRadioButton timedoutTxnBtn;
    private JPieChart txnPieChart;

    public TxPerfGraph(JFrame frame) {
        this.frame = frame;
        timeFormatter.setTimeZone(GMT);
        this.initComponents();
        for (int count = 0; count < this._dataSeries.length; ++count) {
            this._dataSeries[count] = new XYSeries((Comparable)((Object)SERIES_LABELS[count]));
            this._tsDS[count] = new XYSeriesCollection(this._dataSeries[count]);
        }
        this.chart1.setDataset((XYDataset)this._tsDS[0]);
        this.chart1.setTitle(SERIES_LABELS[0]);
        this.chart1.setSubtitle("");
        this.allTxnBtn.setSelected(true);
        this.pieDS = new DefaultPieDataset();
        this.txnPieChart.setDataset((PieDataset)this.pieDS);
        this.txnPieChart.setTitle("All Transactions");
        this.txnPieChart.setSubtitle("(during last time slices)");
        this.periodSelectSlider.setMajorTickSpacing(10);
        this.periodSelectSlider.setToolTipText("Select the number of (" + this.POLL_PERIOD + "ms) time slices over which to show the pie chart");
        SpinnerNumberModel sm1 = new SpinnerNumberModel(this.POLL_PERIOD / 1000, 1, 10000, 1);
        SpinnerNumberModel sm2 = new SpinnerNumberModel(100, 10, 1000, 1);
        this.pollIntervalSpinner.setModel(sm1);
        this.pollIntervalSpinner.setEditor(new JSpinner.NumberEditor(this.pollIntervalSpinner, "#"));
        this.sampleSizeSpinner.setModel(sm2);
        this.sampleSizeSpinner.setEditor(new JSpinner.NumberEditor(this.sampleSizeSpinner, "#"));
        this.pollIntervalSpinner.setVisible(false);
        this.sampleSizeSpinner.setVisible(false);
        this.enableStatsCB.setSelected(false);
        this.resetStatsBtn.setVisible(false);
        this.pollIntervalBtn.setVisible(false);
        this.sampleSizeBtn1.setVisible(false);
        this.taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.newSwingWorker().execute();
            }
        };
        this.swingTimer = new Timer(this.POLL_PERIOD, this.taskPerformer);
        this.chartsPane.setSelectedIndex(1);
    }

    public void setMBeanServerConnection(MBeanServerConnection mbs) {
        this.server = mbs;
        try {
            this.txMBean = JMX.newMBeanProxy(this.server, new ObjectName("jboss.jta:name=TransactionStatistics"), TxStatsMBean.class);
            this.coordMBean = JMX.newMBeanProxy(this.server, new ObjectName("jboss.jta:name=CoordinatorEnvironmentBean"), CoordinatorEnvironmentBeanMBean.class);
            this.coordMBean.setEnableStatistics(true);
            this.enableStatsCB.setSelected(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetStats() {
    }

    private void sample() {
        try {
            ++this.counter;
            long[] stats = new long[]{this.txMBean.getNumberOfTransactions(), this.txMBean.getNumberOfInflightTransactions(), this.txMBean.getNumberOfCommittedTransactions(), this.txMBean.getNumberOfAbortedTransactions(), this.txMBean.getNumberOfHeuristics(), this.txMBean.getNumberOfNestedTransactions(), this.txMBean.getNumberOfTimedOutTransactions()};
            for (int i = 0; i < 7; ++i) {
                this._dataSeries[i].add((double)this.counter, (double)stats[i]);
            }
            if (this.counter > 1L) {
                int slices;
                int cindex = this._dataSeries[0].indexOf((Number)this.counter);
                int lb = cindex < (slices = this.periodSelectSlider.getValue()) ? 0 : cindex - slices;
                for (int i = 0; i < PIE_CHART_SERIES.length; ++i) {
                    XYSeries ts = this._dataSeries[PIE_CHART_SERIES[i]];
                    Number n1 = ts.getDataItem(cindex).getY();
                    Number n2 = ts.getDataItem(lb).getY();
                    this.pieDS.setValue((Comparable)((Object)PIE_CHART_LABELS[i]), (double)(n1.longValue() - n2.longValue()));
                }
                this.txnPieChart.setSubtitle("(during last " + (cindex - lb + 1) + " poll intervals");
            }
        }
        catch (Exception e) {
            System.err.println("MBean property failure: " + e);
        }
    }

    private void initComponents() {
        this.seriesSelectBtnGroup = new ButtonGroup();
        this.configBtnGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.btnPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.allTxnBtn = new JRadioButton();
        this.inFlightTxnBtn = new JRadioButton();
        this.committedTxnBtn = new JRadioButton();
        this.abortedTxnBtn = new JRadioButton();
        this.heuristicTxnBtn = new JRadioButton();
        this.nestedTxnBtn = new JRadioButton();
        this.timedoutTxnBtn = new JRadioButton();
        this.chartsPane = new JTabbedPane();
        this.configTab = new JPanel();
        this.resetStatsBtn = new JButton();
        this.pollIntervalSpinner = new JSpinner();
        this.pollIntervalBtn = new JButton();
        this.enableStatsCB = new JCheckBox();
        this.sampleSizeBtn1 = new JButton();
        this.sampleSizeSpinner = new JSpinner();
        this.chart1 = new JLineChart();
        this.txnPieChart = new JPieChart();
        this.periodSelectPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.periodSelectSlider = new JSlider();
        this.menuBar = new JMenuBar();
        this.setLayout(new BoxLayout(this, 2));
        this.jLabel1.setText("Select Series");
        this.seriesSelectBtnGroup.add(this.allTxnBtn);
        this.allTxnBtn.setText("Transactions");
        this.allTxnBtn.setToolTipText("Show all transactions");
        this.allTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.allTxnBtnActionPerformed(evt);
            }
        });
        this.seriesSelectBtnGroup.add(this.inFlightTxnBtn);
        this.inFlightTxnBtn.setText("In Flight");
        this.inFlightTxnBtn.setToolTipText("Show transactions that have not yet been committed/aborted");
        this.inFlightTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.inFlightTxnBtnActionPerformed(evt);
            }
        });
        this.seriesSelectBtnGroup.add(this.committedTxnBtn);
        this.committedTxnBtn.setText("Committed");
        this.committedTxnBtn.setToolTipText("Show successfully committed transactions");
        this.committedTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.committedTxnBtnActionPerformed(evt);
            }
        });
        this.seriesSelectBtnGroup.add(this.abortedTxnBtn);
        this.abortedTxnBtn.setText("Aborted");
        this.abortedTxnBtn.setToolTipText("Show stats for rolled back transactions");
        this.abortedTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.abortedTxnBtnActionPerformed(evt);
            }
        });
        this.seriesSelectBtnGroup.add(this.heuristicTxnBtn);
        this.heuristicTxnBtn.setText("Heuristics");
        this.heuristicTxnBtn.setToolTipText("Show stats for transactions that terminated with a heuristic outcome");
        this.heuristicTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.heuristicTxnBtnActionPerformed(evt);
            }
        });
        this.seriesSelectBtnGroup.add(this.nestedTxnBtn);
        this.nestedTxnBtn.setText("Nested");
        this.nestedTxnBtn.setToolTipText("Stats for nested transactions");
        this.nestedTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.nestedTxnBtnActionPerformed(evt);
            }
        });
        this.seriesSelectBtnGroup.add(this.timedoutTxnBtn);
        this.timedoutTxnBtn.setText("Timed Out");
        this.timedoutTxnBtn.setToolTipText("Stats for transactions which exceeded there time to live");
        this.timedoutTxnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.timedoutTxnBtnActionPerformed(evt);
            }
        });
        GroupLayout btnPanelLayout = new GroupLayout(this.btnPanel);
        this.btnPanel.setLayout(btnPanelLayout);
        btnPanelLayout.setHorizontalGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btnPanelLayout.createSequentialGroup().addContainerGap().addGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btnPanelLayout.createSequentialGroup().addGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inFlightTxnBtn).addComponent(this.allTxnBtn).addComponent(this.abortedTxnBtn).addComponent(this.committedTxnBtn)).addGap(35, 35, 35).addGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nestedTxnBtn).addComponent(this.heuristicTxnBtn).addComponent(this.timedoutTxnBtn))).addComponent(this.jLabel1)).addContainerGap(188, Short.MAX_VALUE)));
        btnPanelLayout.setVerticalGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, btnPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btnPanelLayout.createSequentialGroup().addComponent(this.heuristicTxnBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nestedTxnBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timedoutTxnBtn)).addGroup(btnPanelLayout.createSequentialGroup().addComponent(this.allTxnBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inFlightTxnBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.committedTxnBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.abortedTxnBtn)))));
        this.chartsPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TxPerfGraph.this.chartsPaneStateChanged(evt);
            }
        });
        this.resetStatsBtn.setText("Reset Stats");
        this.resetStatsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.resetStatsBtnActionPerformed(evt);
            }
        });
        this.pollIntervalSpinner.setToolTipText("Change polling interval (in seconds)");
        this.pollIntervalBtn.setText("Set Poll Interval");
        this.pollIntervalBtn.setToolTipText("Change polling interval (in seconds)");
        this.pollIntervalBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.pollIntervalBtnActionPerformed(evt);
            }
        });
        this.enableStatsCB.setSelected(true);
        this.enableStatsCB.setText("Enable Statistics");
        this.enableStatsCB.setToolTipText("Stop data collection by disabling the stats MBean in the target JVM");
        this.enableStatsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.enableStatsCBActionPerformed(evt);
            }
        });
        this.sampleSizeBtn1.setText("Set Sample Size");
        this.sampleSizeBtn1.setToolTipText("Change polling interval (in seconds)");
        this.sampleSizeBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TxPerfGraph.this.sampleSizeBtn1ActionPerformed(evt);
            }
        });
        this.sampleSizeSpinner.setToolTipText("Change Number of Data Samples ");
        GroupLayout configTabLayout = new GroupLayout(this.configTab);
        this.configTab.setLayout(configTabLayout);
        configTabLayout.setHorizontalGroup(configTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configTabLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(configTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resetStatsBtn, -1, 246, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, configTabLayout.createSequentialGroup().addComponent(this.pollIntervalBtn, -1, 120, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pollIntervalSpinner, -2, 114, -2)).addGroup(configTabLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(configTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableStatsCB).addGroup(configTabLayout.createSequentialGroup().addComponent(this.sampleSizeBtn1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sampleSizeSpinner, -2, 114, -2))))).addGap(149, 149, 149)));
        configTabLayout.setVerticalGroup(configTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configTabLayout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.enableStatsCB).addGap(29, 29, 29).addGroup(configTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleSizeBtn1).addComponent(this.sampleSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(configTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pollIntervalBtn).addComponent(this.pollIntervalSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetStatsBtn).addContainerGap(47, Short.MAX_VALUE)));
        this.chartsPane.addTab("Settings", this.configTab);
        this.chart1.setXAxisLabel("Number of Poll Intervals");
        this.chart1.setXAxisScale(AxisScale.INTEGER);
        this.chart1.setYAxisLabel("Number of Txns");
        this.chart1.setYAxisScale(AxisScale.INTEGER);
        GroupLayout chart1Layout = new GroupLayout((Container)this.chart1);
        this.chart1.setLayout((LayoutManager)chart1Layout);
        chart1Layout.setHorizontalGroup(chart1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 418, Short.MAX_VALUE));
        chart1Layout.setVerticalGroup(chart1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 235, Short.MAX_VALUE));
        this.chartsPane.addTab("Transactions", null, (Component)this.chart1, "View Transaction Statistics");
        GroupLayout txnPieChartLayout = new GroupLayout((Container)this.txnPieChart);
        this.txnPieChart.setLayout((LayoutManager)txnPieChartLayout);
        txnPieChartLayout.setHorizontalGroup(txnPieChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 418, Short.MAX_VALUE));
        txnPieChartLayout.setVerticalGroup(txnPieChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 235, Short.MAX_VALUE));
        this.chartsPane.addTab("Pie Chart", null, (Component)this.txnPieChart, "View Transactions as a Pie Chart");
        this.jLabel2.setText("Time Slices");
        this.jLabel2.setToolTipText("Select the number of polling periods to use for populating the pie chart");
        this.periodSelectSlider.setPaintLabels(true);
        this.periodSelectSlider.setPaintTicks(true);
        this.periodSelectSlider.setToolTipText("Select the number of time slices over which to show the pie chart");
        this.periodSelectSlider.setValue(30);
        GroupLayout periodSelectPanelLayout = new GroupLayout(this.periodSelectPanel);
        this.periodSelectPanel.setLayout(periodSelectPanelLayout);
        periodSelectPanelLayout.setHorizontalGroup(periodSelectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(periodSelectPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodSelectSlider, -1, 334, Short.MAX_VALUE)));
        periodSelectPanelLayout.setVerticalGroup(periodSelectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(periodSelectPanelLayout.createSequentialGroup().addGroup(periodSelectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(periodSelectPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel2, -1, 36, Short.MAX_VALUE)).addComponent(this.periodSelectSlider, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.periodSelectPanel, -1, -1, Short.MAX_VALUE).addComponent(this.chartsPane, GroupLayout.Alignment.TRAILING, -1, 430, Short.MAX_VALUE).addComponent(this.btnPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.chartsPane, -2, 278, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodSelectPanel, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPanel, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.add(this.jPanel1);
        this.add(this.menuBar);
    }

    private void btnActionPerformed(int series) {
        this.chart1.setDataset((XYDataset)this._tsDS[series]);
        this.chart1.setTitle(SERIES_LABELS[series]);
    }

    private void allTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(0);
    }

    private void inFlightTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(1);
    }

    private void heuristicTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(4);
    }

    private void committedTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(2);
    }

    private void abortedTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(3);
    }

    private void nestedTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(5);
    }

    private void timedoutTxnBtnActionPerformed(ActionEvent evt) {
        this.btnActionPerformed(6);
    }

    private void chartsPaneStateChanged(ChangeEvent evt) {
        int tab = this.chartsPane.getSelectedIndex();
        this.btnPanel.setVisible(false);
        this.periodSelectPanel.setVisible(false);
        switch (tab) {
            case 1: {
                this.btnPanel.setVisible(true);
                break;
            }
            case 2: {
                this.periodSelectPanel.setVisible(true);
                break;
            }
        }
    }

    private void pollIntervalBtnActionPerformed(ActionEvent evt) {
        Integer v = (Integer)this.pollIntervalSpinner.getValue();
        this.POLL_PERIOD = v * 1000;
        this.swingTimer.setDelay(this.POLL_PERIOD);
        this.startPolling();
    }

    private void resetStatsBtnActionPerformed(ActionEvent evt) {
        this.resetStats();
    }

    private void enableStatsCBActionPerformed(ActionEvent evt) {
        this.coordMBean.setEnableStatistics(this.enableStatsCB.isSelected());
    }

    private void sampleSizeBtn1ActionPerformed(ActionEvent evt) {
    }

    private void startPolling() {
        if (this.swingTimer.isRunning()) {
            this.swingTimer.restart();
        } else {
            this.swingTimer.start();
        }
    }

    private static void createAndShowGUI(TxPerfGraph perfPanel) {
        JFrame frame = perfPanel.getFrame();
        frame.setDefaultCloseOperation(3);
        JComponent contentPane = (JComponent)frame.getContentPane();
        contentPane.add((Component)perfPanel, "Center");
        contentPane.setOpaque(true);
        contentPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        frame.setContentPane(contentPane);
        frame.pack();
        frame.setVisible(true);
    }

    private static MBeanServerConnection connect(String hostname, int port) {
        String urlPath = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        MBeanServerConnection server = null;
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            server = jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            System.err.println("Unable to get an MBean Server connection: " + e.getMessage());
            System.exit(1);
        }
        return server;
    }

    public SwingWorker<XYSeries[], Object> newSwingWorker() {
        return new Worker();
    }

    void dispose() {
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        final TxPerfGraph graphPanel = new TxPerfGraph(new JFrame("TxPerf"));
        String hostname = "localhost";
        int port = 1090;
        if (args.length > 0) {
            String[] opts = args[0].split(":");
            hostname = opts[0];
            if (opts.length > 1) {
                port = Integer.parseInt(opts[1]);
            }
        }
        System.out.println("Connecting to MBeanServer on endpoint " + hostname + ":" + port);
        MBeanServerConnection server = TxPerfGraph.connect(hostname, port);
        graphPanel.setMBeanServerConnection(server);
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                TxPerfGraph.createAndShowGUI(graphPanel);
            }
        });
        graphPanel.startPolling();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void setDefaultCloseOperation(int operation) {
        this.frame.setDefaultCloseOperation(operation);
    }

    private Container getContentPane() {
        return this.frame.getContentPane();
    }

    private void setJMenuBar(JMenuBar menuBar) {
        this.frame.setJMenuBar(menuBar);
    }

    private void pack() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Worker
    extends SwingWorker<XYSeries[], Object> {
        Worker() {
        }

        @Override
        protected XYSeries[] doInBackground() throws Exception {
            TxPerfGraph.this.sample();
            return TxPerfGraph.this._dataSeries;
        }
    }
}

