/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.utils;

import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileLock {
    public static final int F_RDLCK = 0;
    public static final int F_WRLCK = 1;
    public static final int defaultTimeout = 10;
    public static final int defaultRetry = 10;
    private File _theFile;
    private File _lockFile;
    private File _lockFileLock;
    private long _timeout;
    private long _retry;

    public FileLock(String name) {
        this(new File(name));
        this._theFile.deleteOnExit();
    }

    public FileLock(File name) {
        this(name, 10L, 10L);
    }

    public FileLock(File name, long timeout, long retry) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileLock ( " + name + ", " + timeout + ", " + retry + " )"));
        }
        this._theFile = name;
        this._lockFile = new File(String.valueOf(name.toString()) + "_lock");
        this._lockFileLock = new File(String.valueOf(name.toString()) + "_lock.lock");
        this._timeout = timeout;
        this._retry = retry;
        this._lockFile.deleteOnExit();
        this._lockFileLock.deleteOnExit();
    }

    public boolean lock(int lmode) {
        return this.lock(lmode, false);
    }

    public synchronized boolean lock(int lmode, boolean create) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileLock.lock called for " + this._lockFile));
        }
        boolean created = false;
        if (create && !this._theFile.exists()) {
            this.createFile();
            created = true;
        }
        if (!created && this._lockFile.exists() && lmode == 1) {
            return false;
        }
        int number = 0;
        if (this.lockFile()) {
            DataInputStream ifile2;
            block10: {
                ifile2 = new DataInputStream(new FileInputStream(this._lockFile));
                int value = ifile2.readInt();
                if (value != 1) break block10;
                ifile2.close();
                this.unlockFile();
                return false;
            }
            try {
                number = ifile2.readInt();
                ifile2.close();
            }
            catch (FileNotFoundException ifile2) {
            }
            catch (IOException e) {
                this.unlockFile();
                return false;
            }
            try {
                DataOutputStream ofile = new DataOutputStream(new FileOutputStream(this._lockFile));
                ofile.writeInt(lmode);
                ofile.writeInt(++number);
                ofile.close();
                this.unlockFile();
                return true;
            }
            catch (IOException e) {
                this.unlockFile();
                return false;
            }
        }
        return false;
    }

    public synchronized boolean unlock() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileLock.unlock called " + this._lockFile));
        }
        if (!this._lockFile.exists()) {
            return false;
        }
        if (this.lockFile()) {
            int number = 0;
            int mode = 0;
            try {
                DataInputStream ifile = new DataInputStream(new FileInputStream(this._lockFile));
                mode = ifile.readInt();
                number = ifile.readInt();
                ifile.close();
                if (--number == 0) {
                    this._lockFile.delete();
                    this.unlockFile();
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                this.unlockFile();
                return false;
            }
            catch (IOException e) {
                this.unlockFile();
                return false;
            }
            try {
                DataOutputStream ofile = new DataOutputStream(new FileOutputStream(this._lockFile));
                ofile.writeInt(mode);
                ofile.writeInt(number);
                ofile.close();
                this.unlockFile();
                return true;
            }
            catch (IOException e) {
                this.unlockFile();
                return false;
            }
        }
        return false;
    }

    public static String modeString(int mode) {
        switch (mode) {
            case 0: {
                return "FileLock.F_RDLCK";
            }
            case 1: {
                return "FileLock.F_WRLCK";
            }
        }
        return "Unknown";
    }

    private final boolean createFile() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileLock.createFile " + this._lockFile));
        }
        byte[] b = new byte[1];
        try {
            if (!this._theFile.exists()) {
                this._theFile.createNewFile();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            tsLogger.i18NLogger.warn_utils_FileLock_4(this._lockFile.getName());
            return false;
        }
    }

    private final boolean lockFile() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileLock.lockFile called " + this._lockFile));
        }
        int i = 0;
        while ((long)i < this._retry) {
            block7: {
                if (!this._lockFileLock.createNewFile()) break block7;
                return true;
            }
            try {
                try {
                    Thread.sleep(this._timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }

    private final boolean unlockFile() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileLock.unlockFile called for " + this._lockFile));
        }
        return this._lockFileLock.delete();
    }
}

