/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.LogWriteStateManager;
import com.arjuna.ats.internal.arjuna.abstractrecords.PersistenceRecord;

public class TxLogWritePersistenceRecord
extends PersistenceRecord {
    public TxLogWritePersistenceRecord(OutputObjectState state, ParticipantStore participantStore, StateManager sm) {
        super(state, participantStore, sm);
    }

    @Override
    public int typeIs() {
        return 112;
    }

    @Override
    public int topLevelCommit() {
        boolean result = false;
        LogWriteStateManager sm = null;
        boolean writeToLog = true;
        try {
            sm = (LogWriteStateManager)this.objectAddr;
            writeToLog = sm.writeOptimisation();
        }
        catch (ClassCastException ex) {
            writeToLog = false;
        }
        if (this.targetParticipantStore != null) {
            try {
                if (this.shadowMade) {
                    result = this.targetParticipantStore.commit_state(this.order(), super.getTypeOfObject());
                    if (!result) {
                        tsLogger.i18NLogger.warn_PersistenceRecord_2(this.order());
                    }
                } else if (this.topLevelState != null) {
                    result = !writeToLog ? this.targetParticipantStore.write_committed(this.order(), super.getTypeOfObject(), this.topLevelState) : true;
                }
            }
            catch (ObjectStoreException e) {
                result = false;
            }
        }
        super.forgetAction(true);
        return result ? 7 : 8;
    }

    @Override
    public int topLevelPrepare() {
        int result = 1;
        StateManager sm = this.objectAddr;
        LogWriteStateManager lwsm = null;
        boolean writeToLog = true;
        try {
            lwsm = (LogWriteStateManager)sm;
            writeToLog = lwsm.writeOptimisation();
        }
        catch (ClassCastException ex) {
            writeToLog = false;
        }
        if (sm != null && this.targetParticipantStore != null) {
            this.topLevelState = new OutputObjectState(sm.get_uid(), sm.type());
            if (writeToLog || !this.targetParticipantStore.fullCommitNeeded() && sm.save_state(this.topLevelState, 1) && this.topLevelState.size() <= 4096) {
                if (PersistenceRecord.classicPrepare) {
                    OutputObjectState dummy = new OutputObjectState(Uid.nullUid(), null);
                    try {
                        this.targetParticipantStore.write_uncommitted(sm.get_uid(), sm.type(), dummy);
                        result = 0;
                    }
                    catch (ObjectStoreException e) {
                        tsLogger.i18NLogger.warn_PersistenceRecord_21(e);
                    }
                    dummy = null;
                } else {
                    result = 0;
                }
            } else if (sm.deactivate(this.targetParticipantStore.getStoreName(), false)) {
                this.shadowMade = true;
                result = 0;
            } else {
                tsLogger.i18NLogger.warn_PersistenceRecord_7();
            }
        } else {
            tsLogger.i18NLogger.warn_PersistenceRecord_8();
        }
        return result;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/TxLogPersistenceRecord";
    }

    public TxLogWritePersistenceRecord() {
    }
}

