/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.common;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClassloadingUtility {
    private static final char BREAKCHARACTER = ';';

    public static Class loadClass(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_2(className, e);
            return null;
        }
        return clazz;
    }

    public static <T> Class<? extends T> loadClass(Class<T> iface, String className) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("Loading class " + className));
        }
        if (className == null) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_1();
            return null;
        }
        Class clazz = ClassloadingUtility.loadClass(className);
        if (clazz == null) {
            return null;
        }
        try {
            Class<T> clazz2 = clazz.asSubclass(iface);
            return clazz2;
        }
        catch (ClassCastException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_3(className, iface.getName(), e);
            return null;
        }
    }

    public static <T> T loadAndInstantiateClass(Class<T> iface, String className, String environmentBeanInstanceName) {
        Class<T> clazz;
        T instance;
        block8: {
            instance = null;
            clazz = ClassloadingUtility.loadClass(iface, className);
            if (clazz != null) break block8;
            return null;
        }
        try {
            Constructor<?>[] ctors = clazz.getConstructors();
            Class<?> environmentBeanClass = null;
            Constructor<?>[] constructorArray = ctors;
            int n = ctors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].getCanonicalName().endsWith("EnvironmentBean")) {
                    environmentBeanClass = constructor.getParameterTypes()[0];
                    Object envBean = BeanPopulator.getNamedInstance(environmentBeanClass, environmentBeanInstanceName);
                    instance = (T)constructor.newInstance(envBean);
                    break;
                }
                ++n2;
            }
            if (environmentBeanClass == null && environmentBeanInstanceName == null) {
                instance = clazz.newInstance();
            }
        }
        catch (InstantiationException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_4(className, e);
        }
        catch (IllegalAccessException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_5(className, e);
        }
        catch (InvocationTargetException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_4(className, e);
        }
        return instance;
    }

    public static <T> List<T> loadAndInstantiateClasses(Class<T> iface, List<String> classNames) {
        ArrayList<T> instances = new ArrayList<T>();
        if (classNames != null) {
            for (String className : classNames) {
                T instance = ClassloadingUtility.loadAndInstantiateClass(iface, className, null);
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        return instances;
    }

    public static <T> List<T> loadAndInstantiateClassesWithInit(Class<T> iface, List<String> classNamesWithOptionalInitParams) {
        ArrayList<T> instances = new ArrayList<T>();
        if (classNamesWithOptionalInitParams != null) {
            for (String theClassAndParameter : classNamesWithOptionalInitParams) {
                int breakPosition = theClassAndParameter.indexOf(59);
                String theClass = null;
                String theParameter = null;
                if (breakPosition != -1) {
                    theClass = theClassAndParameter.substring(0, breakPosition);
                    theParameter = theClassAndParameter.substring(breakPosition + 1);
                } else {
                    theClass = theClassAndParameter;
                }
                T instance = ClassloadingUtility.loadAndInstantiateClass(iface, theClass, null);
                if (theClass != null && theParameter != null) {
                    try {
                        Method method = instance.getClass().getMethod("initialise", String.class);
                        method.invoke(instance, theParameter);
                    }
                    catch (Exception e) {
                        tsLogger.i18NLogger.warn_common_ClassloadingUtility_6(theClassAndParameter, e);
                        continue;
                    }
                }
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        return instances;
    }

    public static String getNameForClass(Object instance) {
        if (instance == null) {
            return null;
        }
        return instance.getClass().getName();
    }

    public static List<String> getNamesForClasses(List<? extends Object> instances) {
        ArrayList<String> names = new ArrayList<String>();
        if (instances != null) {
            for (Object object : instances) {
                String name = ClassloadingUtility.getNameForClass(object);
                if (name == null) continue;
                names.add(name);
            }
        }
        return names;
    }
}

