/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.util.concurrent.ConcurrentHashMap;

public class TwoPhaseVolatileStore
extends ObjectStore {
    private ConcurrentHashMap<Uid, StateInstance> _stateMap = new ConcurrentHashMap();

    public TwoPhaseVolatileStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
    }

    @Override
    public boolean allObjUids(String s, InputObjectState buff, int m) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean allTypes(InputObjectState buff) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public int currentState(Uid u, String tn) throws ObjectStoreException {
        StateInstance inst;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TwoPhaseVolatileStore.currentState(Uid=" + u + ", typeName=" + tn + ")"));
        }
        if ((inst = this._stateMap.get(u)) != null) {
            if (inst.original != null) {
                return 1;
            }
            if (inst.shadow != null) {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public String getStoreName() {
        return "TwoPhaseVolatileStore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                throw new ObjectStoreException("Could not find state instance to commit!");
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.shadow != null) {
                    inst.original = inst.shadow;
                    inst.shadow = null;
                    inst.owner = null;
                    return true;
                }
                return false;
            }
        }
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputObjectState read_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TwoPhaseVolatileStore.read_committed(Uid=" + u + ", typeName=" + tn + ")"));
        }
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return null;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.original != null && (inst.owner == null || inst.owner == Thread.currentThread())) {
                    return new InputObjectState(inst.original);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return null;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.shadow != null && (inst.owner == null || inst.owner == Thread.currentThread())) {
                    return new InputObjectState(inst.shadow);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TwoPhaseVolatileStore.remove_committed(Uid=" + u + ", typeName=" + tn + ")"));
        }
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return false;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.original != null && inst.owner == Thread.currentThread()) {
                    inst.original = null;
                    inst.owner = null;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return false;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.shadow != null && inst.owner == Thread.currentThread()) {
                    inst.shadow = null;
                    inst.owner = null;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean write_committed(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TwoPhaseVolatileStore.write_committed(Uid=" + u + ", typeName=" + tn + ")"));
        }
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                this._stateMap.put(u, new StateInstance(buff, null, tn, u, Thread.currentThread()));
            } else {
                StateInstance stateInstance = inst;
                synchronized (stateInstance) {
                    if (inst.original != null) {
                        return false;
                    }
                    inst.original = buff;
                    inst.owner = Thread.currentThread();
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                inst = new StateInstance(null, buff, tn, u, Thread.currentThread());
                this._stateMap.put(u, inst);
            } else {
                if (inst.shadow != null) {
                    return false;
                }
                inst.shadow = buff;
                inst.owner = Thread.currentThread();
            }
            return true;
        }
    }

    @Override
    protected boolean supressEntry(String name) {
        return false;
    }

    private class StateInstance {
        public OutputObjectState original;
        public OutputObjectState shadow;
        public String typeName;
        public Uid uid;
        public Thread owner;

        public StateInstance(OutputObjectState orig, OutputObjectState sd, String tn, Uid u, Thread o) {
            this.original = orig;
            this.shadow = sd;
            this.typeName = tn;
            this.uid = u;
            this.owner = o;
        }

        public String toString() {
            return "StateInstance < original " + (this.original == null ? "empty" : "present") + ", shadow " + (this.shadow == null ? "empty" : "present") + ", " + this.typeName + " " + this.uid + ", " + this.owner + " >";
        }
    }
}

