/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceJDBCAccess
implements JDBCAccess {
    private String datasourceName;
    private InitialContext context;

    @Override
    public Connection getConnection() throws SQLException {
        DataSource dataSource;
        try {
            dataSource = (DataSource)this.context.lookup(this.datasourceName);
        }
        catch (NamingException ex) {
            throw new FatalError(String.valueOf(this.toString()) + " : " + ex, ex);
        }
        Connection connection = dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public void initialise(StringTokenizer tokenizer) {
        while (tokenizer.hasMoreElements()) {
            try {
                String[] split = tokenizer.nextToken().split("=");
                if (!split[0].equalsIgnoreCase("datasourceName")) continue;
                this.datasourceName = split[1];
            }
            catch (Exception ex) {
                throw new FatalError(String.valueOf(this.toString()) + " : " + ex, ex);
            }
        }
        if (this.datasourceName == null) {
            throw new FatalError("The JDBC ObjectStore was not configured with a datasource name");
        }
        try {
            this.context = new InitialContext();
        }
        catch (NamingException ex) {
            throw new FatalError(String.valueOf(this.toString()) + " : " + ex, ex);
        }
    }
}

