/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.drivers;

import com.arjuna.ats.internal.jdbc.DynamicClass;
import com.arjuna.ats.internal.jdbc.drivers.XADataSourceReflectionWrapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.XADataSource;

public class PropertyFileDynamicClass
implements DynamicClass {
    private static final String xaDataSourceClassNameProperty = "xaDataSourceClassName";

    @Override
    public XADataSource getDataSource(String propertyFileName) throws SQLException {
        Properties properties = new Properties();
        FileInputStream propertiesFileInputStream = null;
        try {
            try {
                propertiesFileInputStream = new FileInputStream(propertyFileName);
                properties.load(propertiesFileInputStream);
                propertiesFileInputStream.close();
            }
            catch (IOException e) {
                SQLException sqlException = new SQLException("failed to locate properties file");
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        finally {
            if (propertiesFileInputStream != null) {
                try {
                    propertiesFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String xaDataSourceClassName = properties.getProperty(xaDataSourceClassNameProperty);
        XADataSourceReflectionWrapper xaDataSourceReflectionWrapper = new XADataSourceReflectionWrapper(xaDataSourceClassName);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (xaDataSourceClassNameProperty.equals(propertyName)) continue;
            String propertyValue = (String)properties.get(propertyName);
            try {
                xaDataSourceReflectionWrapper.setProperty(propertyName, propertyValue);
            }
            catch (Exception e) {
                SQLException sqlException = new SQLException("failed to configure XADataSource");
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        return xaDataSourceReflectionWrapper.getWrappedXADataSource();
    }
}

