/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.drivers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.XADataSource;

public class XADataSourceReflectionWrapper {
    private XADataSource xaDataSource;

    XADataSourceReflectionWrapper(String classname) {
        try {
            this.xaDataSource = (XADataSource)Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public void setProperty(String name, String value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methods = this.xaDataSource.getClass().getMethods();
        Method matchingMethod = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(name) && method.getParameterTypes().length == 1) {
                matchingMethod = method;
                break;
            }
            ++n2;
        }
        if (matchingMethod == null) {
            throw new NoSuchMethodException("Could not match " + name);
        }
        Class<?> type = matchingMethod.getParameterTypes()[0];
        Object argument = value;
        if (type == Integer.TYPE) {
            argument = new Integer(value);
        }
        if (type == Boolean.TYPE) {
            argument = new Boolean(value);
        }
        matchingMethod.invoke((Object)this.xaDataSource, argument);
    }

    public XADataSource getWrappedXADataSource() {
        return this.xaDataSource;
    }
}

