/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.drivers.modifiers;

import com.arjuna.ats.internal.arjuna.common.ClassloadingUtility;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModifierFactory {
    private static Hashtable<String, ConnectionModifier> _modifiers = new Hashtable();

    public static synchronized void putModifier(String dbName, int major, int minor, String modclass) {
        ConnectionModifier connectionModifier = ClassloadingUtility.loadAndInstantiateClass(ConnectionModifier.class, modclass, null);
        if (connectionModifier != null) {
            _modifiers.put(String.valueOf(dbName) + "_" + major + "_" + minor, connectionModifier);
        }
    }

    public static synchronized ConnectionModifier getModifier(String dbName, int major, int minor) {
        String exactMatch = null;
        String majorMatch = null;
        String driverMatch = null;
        Enumeration<String> e = _modifiers.keys();
        dbName = dbName.toLowerCase();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (s.equalsIgnoreCase(String.valueOf(dbName) + "_" + major + "_" + minor)) {
                exactMatch = s;
            }
            if (s.equalsIgnoreCase(String.valueOf(dbName) + "_" + major + "_-1")) {
                majorMatch = s;
            }
            if (!s.equalsIgnoreCase(String.valueOf(dbName) + "_-1_-1")) continue;
            driverMatch = s;
        }
        if (exactMatch != null) {
            return _modifiers.get(exactMatch);
        }
        if (majorMatch != null) {
            return _modifiers.get(majorMatch);
        }
        if (driverMatch != null) {
            return _modifiers.get(driverMatch);
        }
        return null;
    }
}

