/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.BasicMutex;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.txoj.LockConflictManager;
import com.arjuna.ats.internal.txoj.LockList;
import com.arjuna.ats.internal.txoj.LockListIterator;
import com.arjuna.ats.internal.txoj.abstractrecords.CadaverLockRecord;
import com.arjuna.ats.internal.txoj.abstractrecords.LockRecord;
import com.arjuna.ats.internal.txoj.lockstore.BasicLockStore;
import com.arjuna.ats.internal.txoj.lockstore.BasicPersistentLockStore;
import com.arjuna.ats.txoj.Lock;
import com.arjuna.ats.txoj.common.txojPropertyManager;
import com.arjuna.ats.txoj.exceptions.LockStoreException;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockManager
extends StateManager {
    public static final int defaultRetry = 100;
    public static final int defaultSleepTime = 250;
    public static final int waitTotalTimeout = -100;
    protected String lockStoreType = txojPropertyManager.getTxojEnvironmentBean().getLockStoreType();
    protected String systemKey;
    protected LockList locksHeld;
    protected final Object locksHeldLockObject = new Object();
    protected LockStore lockStore;
    protected boolean stateLoaded;
    protected boolean hasBeenLocked;
    protected boolean objectLocked;
    protected BasicMutex mutex;
    protected LockConflictManager conflictManager;
    protected static final int DOZE_TIME = 1000000;
    protected static boolean nestedLocking = true;

    static {
        nestedLocking = txojPropertyManager.getTxojEnvironmentBean().isAllowNestedLocking();
    }

    public void finalize() throws Throwable {
        BasicAction action;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LockManager.finalize() for object-id " + this.get_uid() + " type " + this.type()));
        }
        if (this.status() == 3 && (action = BasicAction.Current()) != null && action.status() == 0) {
            tsLogger.i18NLogger.warn_StateManager_1();
            this.cleanup(false);
        }
        boolean doSignal = false;
        this.cleanUp();
        if (this.mutex != null && this.mutex.lock() == 0) {
            doSignal = true;
        }
        this.locksHeld = null;
        this.lockStore = null;
        this.conflictManager = null;
        if (doSignal) {
            this.mutex.unlock();
        }
        this.mutex = null;
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean propagate(Uid from, Uid to) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::propagate(" + from + ", " + to + ")"));
        }
        boolean result = false;
        int retryCount = 10;
        do {
            try {
                Object syncObject;
                Object object = syncObject = BasicAction.Current() == null ? this.getMutex() : BasicAction.Current();
                synchronized (object) {
                    Object object2 = this.locksHeldLockObject;
                    synchronized (object2) {
                        if (this.loadState()) {
                            LockList oldlist = this.locksHeld;
                            Lock current = null;
                            this.locksHeld = new LockList();
                            if (this.locksHeld != null) {
                                while ((current = oldlist.pop()) != null) {
                                    if (current.getCurrentOwner().equals(from)) {
                                        current.propagate();
                                    }
                                    if (this.locksHeld.insert(current)) continue;
                                    current = null;
                                }
                                oldlist = null;
                                result = true;
                            } else {
                                this.freeState();
                                throw new NullPointerException();
                            }
                        }
                        if (result) {
                            result = this.unloadState();
                        }
                    }
                }
            }
            catch (NullPointerException e) {
                result = false;
            }
            if (result) continue;
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!result && --retryCount > 0);
        if (!result) {
            txojLogger.i18NLogger.warn_LockManager_1();
            Object object = this.locksHeldLockObject;
            synchronized (object) {
                this.freeState();
            }
        }
        return result;
    }

    public final boolean releaseAll(Uid actionUid) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::releaseAll(" + actionUid + ")"));
        }
        return this.doRelease(actionUid, true);
    }

    public final boolean releaselock(Uid lockUid) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::releaseLock(" + lockUid + ")"));
        }
        return this.doRelease(lockUid, false);
    }

    public final int setlock(Lock toSet) {
        return this.setlock(toSet, 100, 250);
    }

    public final int setlock(Lock toSet, int retry) {
        return this.setlock(toSet, retry, 250);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setlock(Lock toSet, int retry, int sleepTime) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::setlock(" + toSet + ", " + retry + ", " + sleepTime + ")"));
        }
        int conflict = 0;
        int returnStatus = 1;
        LockRecord newLockR = null;
        boolean modifyRequired = false;
        BasicAction currAct = null;
        if (toSet == null) {
            txojLogger.i18NLogger.warn_LockManager_2();
            return 1;
        }
        currAct = BasicAction.Current();
        if (currAct != null) {
            ActionHierarchy ah = currAct.getHierarchy();
            if (ah != null) {
                toSet.changeHierarchy(ah);
            } else {
                txojLogger.i18NLogger.warn_LockManager_3();
                toSet = null;
                return 1;
            }
        }
        if (super.loadObjectState()) {
            super.setupStore();
        }
        while (conflict == 0 && (retry >= 0 || retry == -100 && sleepTime > 0)) {
            Object syncObject;
            Object object = syncObject = currAct == null ? this.getMutex() : currAct;
            synchronized (object) {
                Object object2 = this.locksHeldLockObject;
                synchronized (object2) {
                    conflict = 0;
                    if (this.loadState()) {
                        conflict = this.lockConflict(toSet);
                    } else {
                        txojLogger.i18NLogger.warn_LockManager_4();
                    }
                    if (conflict != 0) {
                        modifyRequired = toSet.modifiesObject();
                        if (super.activate()) {
                            returnStatus = 0;
                            if (conflict == 1) {
                                int lrStatus = 2;
                                if (currAct != null && (lrStatus = currAct.add(newLockR = new LockRecord(this, !modifyRequired, currAct))) != 2) {
                                    newLockR = null;
                                    if (lrStatus == 3) {
                                        returnStatus = 1;
                                    }
                                }
                                if (returnStatus == 0) {
                                    this.locksHeld.insert(toSet);
                                }
                            }
                        } else {
                            txojLogger.i18NLogger.warn_LockManager_5();
                            returnStatus = 1;
                        }
                    }
                    if (returnStatus == 0 && conflict == 1) {
                        if (!this.unloadState()) {
                            txojLogger.i18NLogger.warn_LockManager_6();
                            returnStatus = 1;
                        }
                    } else {
                        this.freeState();
                    }
                    if (returnStatus == 0 && modifyRequired) {
                        if (super.modified()) {
                            this.hasBeenLocked = true;
                        } else {
                            conflict = 0;
                            returnStatus = 1;
                        }
                    }
                    if (conflict == 0) {
                        this.freeState();
                    }
                }
            }
            if (conflict != 0) continue;
            if (retry != 0) {
                if (sleepTime > 0) {
                    sleepTime -= this.conflictManager.wait(retry, sleepTime);
                } else {
                    retry = 0;
                }
            }
            if (retry == -100) continue;
            --retry;
        }
        return returnStatus;
    }

    @Override
    public void print(PrintWriter strm) {
        LockListIterator next = new LockListIterator(this.locksHeld);
        strm.println("LocalLockManager for object " + this.get_uid());
        if (!this.stateLoaded) {
            strm.println("No loaded state");
        } else if (this.locksHeld != null) {
            Lock current;
            strm.println("\tCurrently holding : " + this.locksHeld.entryCount() + " locks");
            while ((current = next.iterate()) != null) {
                current.print(strm);
            }
        } else {
            strm.println("Currently holding : 0 locks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printState(PrintWriter strm) {
        Object object = this.locksHeldLockObject;
        synchronized (object) {
            boolean iDeleteState = false;
            if (!this.stateLoaded) {
                this.loadState();
                iDeleteState = true;
            }
            this.print(strm);
            if (iDeleteState) {
                this.freeState();
            }
        }
    }

    @Override
    public String type() {
        return "StateManager/LockManager";
    }

    protected LockManager(Uid storeUid) {
        this(storeUid, 1, 0);
    }

    protected LockManager(Uid storeUid, int ot) {
        this(storeUid, ot, 0);
    }

    protected LockManager(Uid storeUid, int ot, int om) {
        super(storeUid, ot, om);
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::LockManager(" + storeUid + ")"));
        }
        this.systemKey = null;
        this.locksHeld = new LockList();
        this.lockStore = null;
        this.mutex = null;
        this.stateLoaded = false;
        this.hasBeenLocked = false;
        this.objectLocked = false;
        this.conflictManager = new LockConflictManager();
    }

    protected LockManager() {
        this(0);
    }

    protected LockManager(int ot) {
        this(ot, 0);
    }

    protected LockManager(int ot, int om) {
        super(ot, om);
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::LockManager(" + ot + ")"));
        }
        this.systemKey = null;
        this.locksHeld = new LockList();
        this.lockStore = null;
        this.mutex = null;
        this.stateLoaded = false;
        this.hasBeenLocked = false;
        this.objectLocked = false;
        this.conflictManager = new LockConflictManager();
    }

    @Override
    protected void terminate() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::terminate() for object-id " + this.get_uid()));
        }
        this.cleanUp();
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanUp() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::cleanUp() for object-id " + this.get_uid()));
        }
        if (this.hasBeenLocked) {
            if (this.objectModel == 1 && this.systemKey == null) {
                this.initialise();
            }
            BasicAction current = BasicAction.Current();
            Hashtable hashtable = this.usingActions;
            synchronized (hashtable) {
                if (this.usingActions != null) {
                    Enumeration e = this.usingActions.elements();
                    while (e.hasMoreElements()) {
                        CadaverLockRecord A;
                        BasicAction action = (BasicAction)e.nextElement();
                        if (action == null || action.add(A = new CadaverLockRecord(this.lockStore, this, action)) == 2) continue;
                        A = null;
                    }
                }
            }
            this.hasBeenLocked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRelease(Uid u, boolean all) {
        Object syncObject;
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::doRelease(" + u + ", " + all + ")"));
        }
        Lock previous = null;
        Lock current = null;
        boolean deleted = false;
        boolean result = false;
        int retryCount = 10;
        boolean loaded = false;
        boolean releasedOK = false;
        BasicAction currAct = BasicAction.Current();
        Object object = syncObject = currAct == null ? this.getMutex() : currAct;
        synchronized (object) {
            Object object2 = this.locksHeldLockObject;
            synchronized (object2) {
                do {
                    if (this.loadState()) {
                        loaded = true;
                        LockListIterator next = new LockListIterator(this.locksHeld);
                        previous = null;
                        while ((current = next.iterate()) != null) {
                            Uid checkUid = null;
                            checkUid = all ? current.getCurrentOwner() : current.get_uid();
                            if (u.equals(checkUid)) {
                                this.locksHeld.forgetNext(previous);
                                current = null;
                                deleted = true;
                                if (all) continue;
                                break;
                            }
                            previous = current;
                        }
                        result = true;
                    } else {
                        this.freeState();
                        result = false;
                    }
                    if (!result) {
                        try {
                            Thread.sleep(1000000L);
                        }
                        catch (InterruptedException next) {}
                        continue;
                    }
                    if (!loaded) {
                        txojLogger.i18NLogger.warn_LockManager_7();
                        continue;
                    }
                    if (!deleted && txojLogger.logger.isTraceEnabled()) {
                        txojLogger.logger.trace((Object)" *** CANNOT locate locks  ***");
                    }
                    int unloadRetryCount = 10;
                    do {
                        if (!this.unloadState()) {
                            txojLogger.i18NLogger.warn_LockManager_8();
                            continue;
                        }
                        releasedOK = true;
                    } while (--unloadRetryCount > 0 && !releasedOK);
                } while (!result && --retryCount > 0);
            }
        }
        this.conflictManager.signal();
        return releasedOK;
    }

    protected final void freeState() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockManager::freeState()");
        }
        if (this.mutex != null) {
            if (this.objectModel != 0) {
                while (this.locksHeld.pop() != null) {
                }
                this.stateLoaded = false;
                if (this.objectLocked) {
                    this.objectLocked = false;
                    this.mutex.unlock();
                }
            } else {
                this.stateLoaded = false;
            }
        } else {
            this.stateLoaded = false;
            this.objectLocked = false;
        }
    }

    protected final boolean initialise() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockManager::initialise()");
        }
        boolean result = false;
        if (this.systemKey == null) {
            this.systemKey = this.type();
            if (this.mutex == null) {
                this.mutex = new BasicMutex();
            }
            if (this.mutex != null) {
                if (this.mutex.lock() == 0 && this.lockStore == null) {
                    try {
                        if (this.lockStoreType.equals(BasicLockStore.class.getName())) {
                            this.lockStore = new BasicLockStore();
                        } else {
                            ObjectStoreEnvironmentBean objectStoreEnvironmentBean = new ObjectStoreEnvironmentBean();
                            objectStoreEnvironmentBean.setLocalOSRoot(this.systemKey);
                            this.lockStore = new BasicPersistentLockStore(objectStoreEnvironmentBean);
                        }
                    }
                    catch (Exception ex) {
                        this.lockStore = null;
                    }
                }
                this.mutex.unlock();
            }
        }
        result = this.lockStore != null;
        return result;
    }

    protected final boolean isAncestorOf(Lock heldLock) {
        BasicAction action;
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::isAncestorOf(" + heldLock.getCurrentOwner() + ")"));
        }
        if ((action = BasicAction.Current()) == null) {
            return false;
        }
        return action.isAncestor(heldLock.getCurrentOwner());
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean loadState() {
        block18: {
            if (txojLogger.logger.isTraceEnabled()) {
                txojLogger.logger.trace((Object)"LockManager::loadState()");
            }
            if (this.objectModel == 0) {
                this.stateLoaded = true;
                return true;
            }
            S = null;
            if (this.systemKey == null && !this.initialise()) {
                return false;
            }
            if (this.mutex == null || this.mutex.tryLock() == 2) {
                return false;
            }
            this.stateLoaded = false;
            this.objectLocked = true;
            try {
                block19: {
                    block17: {
                        S = this.lockStore.read_state(this.get_uid(), this.type());
                        if (S == null) break block19;
                        u = null;
                        current = null;
                        count = 0;
                        try {
                            count = S.unpackInt();
                            cleanLoad = true;
                            if (txojLogger.logger.isTraceEnabled()) {
                                txojLogger.logger.trace((Object)("LockManager::loadState() loading " + count + " lock(s)"));
                            }
                            i = 0;
                            while (i < count && cleanLoad) {
                                try {
                                    u = UidHelper.unpackFrom(S);
                                    current = new Lock(u);
                                    if (current != null) {
                                        if (current.restore_state(S, 1)) {
                                            this.locksHeld.push(current);
                                        } else {
                                            current = null;
                                            cleanLoad = false;
                                        }
                                    } else {
                                        cleanLoad = false;
                                    }
                                }
                                catch (IOException e) {
                                    cleanLoad = false;
                                }
                                ++i;
                            }
                            if (!cleanLoad) ** GOTO lbl46
                            this.stateLoaded = true;
                            break block17;
lbl-1000:
                            // 1 sources

                            {
                                current = null;
lbl46:
                                // 2 sources

                                ** while ((current = this.locksHeld.pop()) != null)
                            }
lbl47:
                            // 1 sources

                        }
                        catch (IOException var5_7) {
                            // empty catch block
                        }
                    }
                    S = null;
                    break block18;
                }
                this.stateLoaded = true;
            }
            catch (LockStoreException e) {
                txojLogger.logger.warn((Object)e);
            }
        }
        return this.stateLoaded;
    }

    protected final int lockConflict(Lock otherLock) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::lockConflict(" + otherLock.get_uid() + ")"));
        }
        boolean matching = false;
        Lock heldLock = null;
        LockListIterator next = new LockListIterator(this.locksHeld);
        while ((heldLock = next.iterate()) != null) {
            if (heldLock.conflictsWith(otherLock)) {
                if (nestedLocking) {
                    if (this.isAncestorOf(heldLock)) continue;
                    return 0;
                }
                return 0;
            }
            if (!heldLock.equals(otherLock)) continue;
            matching = true;
        }
        return matching ? 2 : 1;
    }

    protected final boolean unloadState() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockManager::unloadState()");
        }
        if (this.objectModel == 0) {
            this.stateLoaded = false;
            return true;
        }
        boolean unloadOk = false;
        Lock current = null;
        String otype = this.type();
        Uid u = this.get_uid();
        OutputObjectState S = new OutputObjectState(u, otype);
        int lockCount = this.locksHeld.entryCount();
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::unloadState() unloading " + lockCount + " lock(s)"));
        }
        if (lockCount == 0) {
            if (this.lockStore.remove_state(u, otype)) {
                unloadOk = true;
            } else {
                txojLogger.i18NLogger.warn_LockManager_10(u, otype);
            }
        } else {
            try {
                S.packInt(lockCount);
                unloadOk = true;
                while ((current = this.locksHeld.pop()) != null) {
                    UidHelper.packInto(current.get_uid(), S);
                    if (!current.save_state(S, 1)) {
                        txojLogger.i18NLogger.warn_LockManager_11(current.toString());
                        unloadOk = false;
                    }
                    current = null;
                }
                if (unloadOk) {
                    unloadOk = false;
                    if (S.valid() && this.lockStore.write_committed(u, otype, S)) {
                        unloadOk = true;
                    } else {
                        txojLogger.i18NLogger.warn_LockManager_12(u, otype);
                    }
                }
            }
            catch (IOException e) {
                unloadOk = false;
                txojLogger.i18NLogger.warn_LockManager_13(u, otype);
            }
        }
        this.stateLoaded = false;
        if (this.objectLocked) {
            this.objectLocked = false;
            if (this.mutex != null) {
                this.mutex.unlock();
            }
        }
        return unloadOk;
    }
}

