/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.propertyservice;

import com.arjuna.common.util.ConfigurationInfo;
import com.arjuna.common.util.propertyservice.FileLocator;
import com.arjuna.common.util.propertyservice.StringPropertyReplacer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PropertiesFactory {
    private static volatile Properties defaultProperties = null;

    public static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            PropertiesFactory.initDefaultProperties("com.arjuna.ats.arjuna.common.propertiesFile");
        }
        return defaultProperties;
    }

    public static Properties getPropertiesFromFile(String propertyFileName, ClassLoader classLoader) {
        String propertiesSourceUri = null;
        try {
            propertiesSourceUri = FileLocator.locateFile(propertyFileName, classLoader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            URL url = PropertiesFactory.class.getResource("/default-" + propertyFileName);
            if (url == null) {
                throw new RuntimeException("missing property file " + propertyFileName);
            }
            propertiesSourceUri = url.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("invalid property file " + propertiesSourceUri, e);
        }
        Properties properties = null;
        try {
            properties = PropertiesFactory.loadFromFile(propertiesSourceUri);
            properties = PropertiesFactory.applySystemProperties(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to load properties from " + propertiesSourceUri, e);
        }
        return properties;
    }

    private static Properties applySystemProperties(Properties inputProperties) {
        Properties outputProperties = new Properties(inputProperties);
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            outputProperties.setProperty(key, System.getProperty(key));
        }
        return outputProperties;
    }

    private static Properties loadFromFile(String uri) throws IOException {
        InputStream inputStream = null;
        Properties inputProperties = new Properties();
        Properties outputProperties = new Properties();
        inputStream = new File(uri).exists() ? new FileInputStream(uri) : new URL(uri).openStream();
        try {
            PropertiesFactory.loadFromXML(inputProperties, inputStream);
        }
        finally {
            inputStream.close();
        }
        Enumeration<?> namesEnumeration = inputProperties.propertyNames();
        while (namesEnumeration.hasMoreElements()) {
            String propertyName = (String)namesEnumeration.nextElement();
            String propertyValue = inputProperties.getProperty(propertyName);
            propertyValue = propertyValue.trim();
            propertyValue = StringPropertyReplacer.replaceProperties(propertyValue);
            outputProperties.setProperty(propertyName, propertyValue);
        }
        return outputProperties;
    }

    private static Properties loadFromXML(Properties p, InputStream is) throws IOException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(new XMLResolver(){

                @Override
                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return new ByteArrayInputStream(new byte[0]);
                }
            });
            XMLStreamReader parser = inputFactory.createXMLStreamReader(is);
            int event = -1;
            while (true) {
                if (event == 8) {
                    parser.close();
                    break;
                }
                if (event == 1 && parser.getAttributeCount() > 0) {
                    String key = parser.getAttributeValue(0);
                    StringBuffer buffer = new StringBuffer();
                    event = parser.next();
                    while (event == 4 || event == 5) {
                        if (event != 5) {
                            String nextText = parser.getText();
                            buffer.append(nextText);
                        }
                        event = parser.next();
                    }
                    if (key == null) continue;
                    String value = buffer.toString();
                    p.put(key, value);
                    continue;
                }
                event = parser.next();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Could not read xml", e);
        }
        return null;
    }

    private static synchronized void initDefaultProperties(String fileNamePropertyKey) {
        if (defaultProperties != null) {
            return;
        }
        String propertyFileName = System.getProperty(fileNamePropertyKey);
        if (propertyFileName == null) {
            propertyFileName = ConfigurationInfo.getPropertiesFile();
        }
        if (propertyFileName == null) {
            throw new RuntimeException("Unable to resolve property file name");
        }
        defaultProperties = PropertiesFactory.getPropertiesFromFile(propertyFileName, PropertiesFactory.class.getClassLoader());
    }
}

