/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jts.OTSManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_UNAVAILABLE;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;

public class BaseTransaction {
    private static boolean _supportSubtransactions = false;

    public void begin() throws NotSupportedException, javax.transaction.SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"BaseTransaction.begin");
        }
        if (!_supportSubtransactions) {
            try {
                this.checkTransactionState();
            }
            catch (IllegalStateException e1) {
                NotSupportedException notSupportedException = new NotSupportedException(e1.getMessage());
                notSupportedException.initCause((Throwable)e1);
                throw notSupportedException;
            }
            catch (SystemException e2) {
                javax.transaction.SystemException systemException = new javax.transaction.SystemException(e2.toString());
                systemException.initCause((Throwable)e2);
                throw systemException;
            }
        }
        try {
            TransactionImple.putTransaction(new TransactionImple());
        }
        catch (SubtransactionsUnavailable e3) {
            NotSupportedException notSupportedException = new NotSupportedException(e3.getMessage());
            notSupportedException.initCause((Throwable)((Object)e3));
            throw notSupportedException;
        }
        catch (SystemException e4) {
            javax.transaction.SystemException systemException = new javax.transaction.SystemException(e4.toString());
            systemException.initCause((Throwable)e4);
            throw systemException;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, javax.transaction.SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"BaseTransaction.commit");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            theTransaction.commitAndDisassociate();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw new IllegalStateException("BaseTransaction.commit - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_notxe() + ex, ex);
        }
        this.checkTransactionState();
    }

    public void rollback() throws IllegalStateException, SecurityException, javax.transaction.SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"BaseTransaction.rollback");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            theTransaction.rollbackAndDisassociate();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException(ex);
        }
        this.checkTransactionState();
    }

    public void setRollbackOnly() throws IllegalStateException, javax.transaction.SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"BaseTransaction.setRollbackOnly");
        }
        TransactionImple theTransaction = TransactionImple.getTransaction();
        try {
            theTransaction.setRollbackOnly();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_nosuchtx(), ex);
        }
    }

    public int getStatus() throws javax.transaction.SystemException {
        TransactionImple theTransaction;
        block7: {
            if (jtaxLogger.logger.isTraceEnabled()) {
                jtaxLogger.logger.trace((Object)"BaseTransaction.getStatus");
            }
            theTransaction = null;
            try {
                theTransaction = TransactionImple.getTransaction();
            }
            catch (TRANSACTION_UNAVAILABLE e) {
                if (e.minor != 1) break block7;
                return 6;
            }
        }
        if (theTransaction == null) {
            return 6;
        }
        try {
            return theTransaction.getStatus();
        }
        catch (NullPointerException ex) {
            return 6;
        }
        catch (Exception e) {
            javax.transaction.SystemException systemException = new javax.transaction.SystemException(e.toString());
            systemException.initCause((Throwable)e);
            throw systemException;
        }
    }

    public void setTransactionTimeout(int seconds) throws javax.transaction.SystemException {
        try {
            OTSImpleManager.current().set_timeout(seconds);
        }
        catch (Exception e) {
            javax.transaction.SystemException systemException = new javax.transaction.SystemException(e.toString());
            systemException.initCause((Throwable)e);
            throw systemException;
        }
    }

    public int getTimeout() throws javax.transaction.SystemException {
        try {
            return OTSImpleManager.current().get_timeout();
        }
        catch (Exception e) {
            javax.transaction.SystemException systemException = new javax.transaction.SystemException(e.toString());
            systemException.initCause((Throwable)e);
            throw systemException;
        }
    }

    protected BaseTransaction() {
    }

    final void checkTransactionState() throws IllegalStateException, javax.transaction.SystemException {
        try {
            Control cont = OTSManager.get_current().get_control();
            if (cont != null) {
                Coordinator coord = cont.get_coordinator();
                if (coord != null && coord.get_status() == Status.StatusActive && !_supportSubtransactions) {
                    throw new IllegalStateException("BaseTransaction.checkTransactionState - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_alreadyassociated());
                }
                cont = null;
            }
        }
        catch (SystemException e1) {
            javax.transaction.SystemException systemException = new javax.transaction.SystemException(e1.toString());
            systemException.initCause((Throwable)e1);
            throw systemException;
        }
        catch (Unavailable unavailable) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static {
        _supportSubtransactions = jtaPropertyManager.getJTAEnvironmentBean().isSupportSubtransactions();
    }
}

