/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StateType;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;
import java.io.File;
import java.io.IOException;

public class HashedStore
extends ShadowNoFileLockStore {
    public static final char SHADOWCHAR = '!';
    public static final int DEFAULT_NUMBER_DIRECTORIES = 255;
    private static final String HASH_SEPARATOR = "#";
    private static int NUMBEROFDIRECTORIES = 255;

    @Override
    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        File f;
        String[] entry;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HashedStore.allObjUids(" + tName + ", " + state + ", " + match + ")"));
        }
        String directory = this.locateStore(this.getStoreName());
        OutputObjectState store = new OutputObjectState();
        directory = tName != null && tName.length() > 0 && tName.charAt(0) == File.separatorChar ? directory + tName.substring(1, tName.length()) : directory + tName;
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        if ((entry = (f = new File(directory)).list()) != null && entry.length > 0) {
            for (int i = 0; i < entry.length; ++i) {
                File dir;
                if (!Character.isDigit(entry[i].charAt(1)) && !entry[i].startsWith(HASH_SEPARATOR) || !(dir = new File(directory + entry[i])).isDirectory()) continue;
                String[] dirEnt = dir.list();
                for (int j = 0; j < dirEnt.length; ++j) {
                    try {
                        Uid aUid = new Uid(dirEnt[j], true);
                        if (!aUid.valid() || aUid.equals(Uid.nullUid())) {
                            String revealed = this.revealedId(dirEnt[j]);
                            aUid = this.present(revealed, dirEnt) ? null : new Uid(revealed);
                        }
                        if (!aUid.notEquals(Uid.nullUid()) || match != -1 && !this.isType(aUid, tName, match) || !this.scanZeroLengthFiles && new File(dir, dirEnt[j]).length() <= 0L) continue;
                        UidHelper.packInto(aUid, store);
                        continue;
                    }
                    catch (NumberFormatException aUid) {
                        continue;
                    }
                    catch (IOException e) {
                        throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_HashedStore_5(), e);
                    }
                }
            }
        }
        try {
            UidHelper.packInto(Uid.nullUid(), store);
        }
        catch (IOException e) {
            throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_HashedStore_6(), e);
        }
        state.setBuffer(store.buffer());
        store = null;
        return true;
    }

    public HashedStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
    }

    @Override
    protected String truncate(String value) {
        int nextIndex;
        int lastIndex = value.lastIndexOf(HASH_SEPARATOR);
        String toReturn = value;
        if (lastIndex != -1 && (nextIndex = value.lastIndexOf(HASH_SEPARATOR, lastIndex - 1)) != -1) {
            char[] bitInbetween = new char[lastIndex - nextIndex - 1];
            boolean isDigit = true;
            value.getChars(nextIndex + 1, lastIndex, bitInbetween, 0);
            for (int i = 0; i < bitInbetween.length && isDigit; ++i) {
                if (Character.isDigit(bitInbetween[i])) continue;
                isDigit = false;
            }
            if (isDigit) {
                toReturn = value.substring(lastIndex + 1);
            }
        }
        return toReturn;
    }

    @Override
    protected String genPathName(Uid objUid, String tName, int otype) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HashedStore.genPathName(" + objUid + ", " + tName + ", " + StateType.stateTypeString(otype) + ")"));
        }
        String storeName = this.locateStore(this.getStoreName());
        String fname = null;
        String cPtr = null;
        int uidHash = objUid.hashCode();
        String os = objUid.fileStringForm();
        String hashDir = HASH_SEPARATOR + uidHash % NUMBEROFDIRECTORIES + HASH_SEPARATOR + File.separator;
        if (tName == null || tName.length() == 0) {
            cPtr = "";
        } else {
            cPtr = tName;
            if (FileSystemStore.rewriteSeparator && cPtr.indexOf(47) != -1) {
                cPtr = cPtr.replace('/', File.separatorChar);
            }
        }
        if (cPtr.charAt(0) == File.separatorChar) {
            cPtr = cPtr.substring(1, cPtr.length());
        }
        if ((fname = cPtr.charAt(cPtr.length() - 1) != File.separatorChar ? storeName + cPtr + File.separator + hashDir + os : storeName + cPtr + hashDir + os).charAt(fname.length() - 1) == File.separatorChar) {
            fname = fname.substring(0, fname.length() - 2);
        }
        if (otype == 10) {
            fname = fname + '!';
        }
        return fname;
    }

    private final boolean present(String id, String[] list2) {
        for (int i = 0; i < list2.length; ++i) {
            if (!list2[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    static {
        NUMBEROFDIRECTORIES = arjPropertyManager.getObjectStoreEnvironmentBean().getHashedDirectories();
        if (NUMBEROFDIRECTORIES <= 0) {
            tsLogger.i18NLogger.warn_objectstore_HashedStore_2(Integer.toString(NUMBEROFDIRECTORIES));
            NUMBEROFDIRECTORIES = 255;
        }
    }
}

