/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.resources.spi.XATerminatorExtensions;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporterImple;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.coordinator.ServerTransaction;
import com.arjuna.ats.jta.exceptions.UnexpectedConditionException;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.TransactionImportResult;

public class XATerminatorImple
implements XATerminator,
XATerminatorExtensions,
ExtendedJBossXATerminator {
    private boolean _recoveryStarted = false;
    private static final Xid[] NO_XIDS = new Xid[0];

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            if (tx2.baseXid() != null) {
                if (onePhase) {
                    tx2.doOnePhaseCommit();
                } else if (!tx2.doCommit()) {
                    throw new XAException(-7);
                }
            } else {
                throw new XAException(4);
            }
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
        catch (RollbackException e) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(100);
            xaException.initCause(e);
            throw xaException;
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicCommitException ex) {
            XAException xaException = new XAException(7);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicRollbackException ex) {
            XAException xaException = new XAException(6);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicMixedException ex) {
            XAException xaException = new XAException(5);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (IllegalStateException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-4);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (SystemException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            tx2.doForget();
        }
        catch (Exception ex) {
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
        finally {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
        if (tx2 == null) {
            throw new XAException(-5);
        }
        switch (tx2.doPrepare()) {
            case 2: {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                return 3;
            }
            case 1: {
                try {
                    this.rollback(xid);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                throw new XAException(100);
            }
            case 0: {
                return 0;
            }
            case 11: {
                throw new XAException(-4);
            }
        }
        throw new XAException(104);
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] indoubt;
        block15: {
            switch (flag) {
                case 0x1000000: {
                    if (this._recoveryStarted) {
                        throw new XAException(-6);
                    }
                    this._recoveryStarted = true;
                    break;
                }
                case 0x800000: {
                    if (!this._recoveryStarted) {
                        throw new XAException(-6);
                    }
                    this._recoveryStarted = false;
                    return null;
                }
                case 0: {
                    if (this._recoveryStarted) break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            indoubt = null;
            try {
                RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
                InputObjectState states = new InputObjectState();
                if (!recoveryStore.allObjUids(ServerTransaction.getType(), states) || !states.notempty()) break block15;
                Stack<SubordinateTransaction> values = new Stack<SubordinateTransaction>();
                boolean finished = false;
                do {
                    Uid uid = null;
                    try {
                        uid = UidHelper.unpackFrom(states);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        finished = true;
                    }
                    if (uid.notEquals(Uid.nullUid())) {
                        SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().recoverTransaction(uid);
                        values.push(tx2);
                        continue;
                    }
                    finished = true;
                } while (!finished);
                if (values.size() > 0) {
                    int index = 0;
                    indoubt = new Xid[values.size()];
                    while (!values.empty()) {
                        TransactionImple id = (TransactionImple)values.pop();
                        indoubt[index] = id.baseXid();
                        ++index;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return indoubt;
    }

    public void rollback(Xid xid) throws XAException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            if (tx2.baseXid() == null) {
                throw new XAException(4);
            }
            tx2.doRollback();
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicCommitException ex) {
            XAException xaException = new XAException(7);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicRollbackException ex) {
            XAException xaException = new XAException(6);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicMixedException ex) {
            XAException xaException = new XAException(5);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (IllegalStateException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-4);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (SystemException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
    }

    @Override
    public boolean beforeCompletion(Xid xid) throws SystemException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new UnexpectedConditionException();
            }
            return tx2.doBeforeCompletion();
        }
        catch (Exception ex) {
            UnexpectedConditionException e = new UnexpectedConditionException();
            e.initCause(ex);
            throw e;
        }
    }

    public Transaction getTransaction(Xid xid) throws XAException {
        return com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple.getTransaction(new XidImple(xid).getTransactionUid());
    }

    public TransactionImportResult importTransaction(Xid xid, int timeoutIfNew) throws XAException {
        return SubordinationManager.getTransactionImporter().importRemoteTransaction(xid, timeoutIfNew);
    }

    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        TransactionImporter transactionImporter = SubordinationManager.getTransactionImporter();
        return transactionImporter.getImportedTransaction(xid);
    }

    public Transaction getTransactionById(Object id) {
        return com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple.getTransaction((Uid)id);
    }

    public Object getCurrentTransactionId() {
        return com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple.getTransaction().get_uid();
    }

    public void removeImportedTransaction(Xid xid) throws XAException {
        SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
    }

    public Xid[] getXidsToRecoverForParentNode(boolean recoverInFlight, String parentNodeName, int recoveryFlags) throws XAException {
        Xid[] inDoubtTransactions;
        XATerminator xaTerminator;
        Set<Xid> inFlightXids;
        TransactionImporter transactionImporter;
        HashSet<Xid> xidsToRecover = new HashSet<Xid>();
        if (recoverInFlight && (transactionImporter = SubordinationManager.getTransactionImporter()) instanceof TransactionImporterImple && (inFlightXids = ((TransactionImporterImple)transactionImporter).getInflightXids(parentNodeName)) != null) {
            xidsToRecover.addAll(inFlightXids);
        }
        if ((xaTerminator = SubordinationManager.getXATerminator()) instanceof com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple) {
            inDoubtTransactions = ((com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple)xaTerminator).doRecover(null, parentNodeName);
            if (inDoubtTransactions != null) {
                xidsToRecover.addAll(Arrays.asList(inDoubtTransactions));
            }
        } else {
            inDoubtTransactions = xaTerminator.recover(recoveryFlags);
            if (inDoubtTransactions != null) {
                xidsToRecover.addAll(Arrays.asList(inDoubtTransactions));
            }
        }
        return xidsToRecover.toArray(NO_XIDS);
    }

    public Xid[] doRecover(Xid xid, String parentNodeName) throws XAException, NotSupportedException {
        throw new NotSupportedException();
    }

    public boolean isRecoveryByNodeOrXidSupported() {
        return false;
    }
}

