/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util;

import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ConfigurationInfo {
    private static volatile String sourceId = "unknown";
    private static volatile String propertiesFile = "arjuna-properties.xml";
    private static volatile String buildId = "arjuna-builder";

    public static String getVersion() {
        return ConfigurationInfo.getSourceId();
    }

    public static String getSourceId() {
        return sourceId;
    }

    public static String getPropertiesFile() {
        return propertiesFile;
    }

    public static String getBuildId() {
        return buildId;
    }

    public static void main(String[] args) {
        System.out.println("sourceId: " + ConfigurationInfo.getSourceId());
        System.out.println("propertiesFile: " + ConfigurationInfo.getPropertiesFile());
        String beans = BeanPopulator.printState();
        System.out.print(beans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBuildTimeProperties() {
        String classFileName = ConfigurationInfo.class.getSimpleName() + ".class";
        String pathToThisClass = ConfigurationInfo.class.getResource(classFileName).toString();
        int suffixLength = ("/" + ConfigurationInfo.class.getCanonicalName() + ".class").length();
        String basePath = pathToThisClass.substring(0, pathToThisClass.length() - suffixLength);
        String pathToManifest = basePath + "/META-INF/MANIFEST.MF";
        InputStream is = null;
        try {
            is = new URL(pathToManifest).openStream();
            Manifest manifest = new Manifest(is);
            Attributes attributes = manifest.getMainAttributes();
            Attributes.Name name = new Attributes.Name("arjuna-properties-file");
            if (attributes.containsKey(name)) {
                propertiesFile = attributes.getValue(name);
            }
            if (attributes.containsKey(name = new Attributes.Name("arjuna-scm-revision"))) {
                sourceId = attributes.getValue(name);
            }
            if (attributes.containsKey(name = new Attributes.Name("arjuna-builder"))) {
                buildId = attributes.getValue(name);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        ConfigurationInfo.getBuildTimeProperties();
    }
}

