/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarjtx.client;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationCoordinatorRPCPortType;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.WSARJTXClient;
import java.io.IOException;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPBuilderFactory;

public class TerminationCoordinatorRPCClient {
    private static final TerminationCoordinatorRPCClient CLIENT = new TerminationCoordinatorRPCClient();
    private String completeAction = null;
    private String closeAction = null;
    private String cancelAction = null;

    private TerminationCoordinatorRPCClient() {
        MAPBuilder builder = MAPBuilderFactory.getInstance().getBuilderInstance();
        this.completeAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Complete";
        this.closeAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Close";
        this.cancelAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Cancel";
    }

    public void sendComplete(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault11, IOException {
        TerminationCoordinatorRPCPortType port = this.getPort(coordinator, map, this.completeAction);
        NotificationType complete = new NotificationType();
        try {
            port.completeOperation(complete);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public void sendClose(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault11, IOException {
        TerminationCoordinatorRPCPortType port = this.getPort(coordinator, map, this.closeAction);
        NotificationType close = new NotificationType();
        try {
            port.closeOperation(close);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public void sendCancel(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault11, IOException {
        TerminationCoordinatorRPCPortType port = this.getPort(coordinator, map, this.cancelAction);
        NotificationType cancel = new NotificationType();
        try {
            port.cancelOperation(cancel);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public static TerminationCoordinatorRPCClient getClient() {
        return CLIENT;
    }

    private TerminationCoordinatorRPCPortType getPort(W3CEndpointReference endpoint, MAP map, String action) {
        return WSARJTXClient.getTerminationCoordinatorRPCPort(endpoint, action, map);
    }
}

