/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.acessor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.umdm.Accessor;
import org.jboss.ws.metadata.umdm.AccessorFactory;
import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;

public class ReflectiveMethodAccessor
implements Accessor {
    private Method getter;
    private Method setter;
    public static AccessorFactoryCreator FACTORY_CREATOR = new AccessorFactoryCreator(){

        public AccessorFactory create(ParameterMetaData parameter) {
            return this.create(parameter.getJavaType());
        }

        public AccessorFactory create(FaultMetaData fault) {
            return this.create(fault.getFaultBean());
        }

        private AccessorFactory create(final Class clazz) {
            return new AccessorFactory(){

                public Accessor create(WrappedParameter parameter) {
                    try {
                        PropertyDescriptor pd = new PropertyDescriptor(parameter.getVariable(), clazz);
                        return new ReflectiveMethodAccessor(pd.getReadMethod(), pd.getWriteMethod());
                    }
                    catch (Throwable t) {
                        WSException ex = new WSException(t.getMessage());
                        ex.setStackTrace(t.getStackTrace());
                        throw ex;
                    }
                }
            };
        }
    };

    private ReflectiveMethodAccessor(Method getter, Method setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public Object get(Object bean) {
        try {
            return this.getter.invoke(bean, new Object[0]);
        }
        catch (Throwable e) {
            WSException ex = new WSException(e.getMessage());
            ex.setStackTrace(ex.getStackTrace());
            throw ex;
        }
    }

    public void set(Object bean, Object value) {
        try {
            this.setter.invoke(bean, value);
        }
        catch (Throwable e) {
            WSException ex = new WSException(e.getMessage());
            ex.setStackTrace(ex.getStackTrace());
            throw ex;
        }
    }
}

