/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCSignature {
    private Collection<WSDLRPCPart> parameters = new ArrayList<WSDLRPCPart>();
    private WSDLRPCPart returnParameter;

    public Collection<WSDLRPCPart> parameters() {
        return this.parameters;
    }

    public WSDLRPCPart returnParameter() {
        return this.returnParameter;
    }

    public RPCSignature(WSDLInterfaceOperation operation) {
        WSDLInterfaceOperationInput input = WSDLUtils.getWsdl11Input(operation);
        WSDLInterfaceOperationOutput output = WSDLUtils.getWsdl11Output(operation);
        for (WSDLRPCSignatureItem item : operation.getRpcSignatureItems()) {
            if (item.getDirection() == WSDLRPCSignatureItem.Direction.RETURN) {
                if (output == null) continue;
                this.returnParameter = output.getChildPart(item.getName());
                continue;
            }
            WSDLRPCPart part = null;
            if (input != null) {
                part = input.getChildPart(item.getName());
            }
            if (output != null && part == null) {
                part = output.getChildPart(item.getName());
            }
            if (part == null) continue;
            this.parameters.add(part);
        }
        for (WSDLRPCPart part : input.getChildParts()) {
            if (operation.getRpcSignatureitem(part.getName()) != null) continue;
            this.parameters.add(part);
        }
        if (output != null) {
            for (WSDLRPCPart part : output.getChildParts()) {
                if (operation.getRpcSignatureitem(part.getName()) != null || input.getChildPart(part.getName()) != null) continue;
                if (this.returnParameter == null) {
                    this.returnParameter = part;
                    continue;
                }
                this.parameters.add(part);
            }
        }
    }
}

