/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.mapping;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.NamespacePackageMapping;
import org.jboss.ws.tools.helpers.MappingFileGeneratorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileGenerator {
    protected WSDLDefinitions wsdlDefinitions;
    protected Map<String, String> namespacePackageMap = new HashMap<String, String>();
    protected String serviceName;
    protected String packageName;
    protected Class serviceEndpointInterface = null;
    protected LiteralTypeMapping typeMapping = null;
    protected String parameterStyle;

    public MappingFileGenerator(WSDLDefinitions wsdl, TypeMapping typeM) {
        this.wsdlDefinitions = wsdl;
        String targetNS = wsdl.getTargetNamespace();
        this.packageName = NamespacePackageMapping.getJavaPackageName(targetNS);
        this.typeMapping = (LiteralTypeMapping)typeM;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public void setWsdlDefinitions(WSDLDefinitions wsdlDefinitions) {
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Map<String, String> getNamespacePackageMap() {
        return this.namespacePackageMap;
    }

    public void setNamespacePackageMap(Map<String, String> map) {
        this.namespacePackageMap = map;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceEndpointInterface(Class serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setParameterStyle(String paramStyle) {
        this.parameterStyle = paramStyle;
    }

    public JavaWsdlMapping generate() throws IOException {
        MappingFileGeneratorHelper helper = new MappingFileGeneratorHelper(this.wsdlDefinitions, this.serviceName, this.namespacePackageMap, this.serviceEndpointInterface, this.typeMapping, this.parameterStyle);
        JavaWsdlMapping jwm = new JavaWsdlMapping();
        helper.constructJavaXmlTypeMapping(jwm);
        WSDLService[] services = this.wsdlDefinitions.getServices();
        int lenServices = 0;
        if (services != null) {
            lenServices = services.length;
        }
        for (int i = 0; i < lenServices; ++i) {
            WSDLService wsdlService = services[i];
            jwm.addServiceInterfaceMappings(helper.constructServiceInterfaceMapping(jwm, wsdlService));
            helper.constructServiceEndpointInterfaceMapping(jwm, wsdlService);
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        String typeNamespace = helper.getTypeNamespace();
        if (typeNamespace == null) {
            typeNamespace = targetNS;
        }
        if (typeNamespace != null && !typeNamespace.equals(targetNS) || this.isServerSideGeneration()) {
            jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.getPackageName(typeNamespace), typeNamespace));
        }
        jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.getPackageName(targetNS), targetNS));
        if (this.namespacePackageMap != null) {
            Set<String> keys = this.namespacePackageMap.keySet();
            Iterator<String> iter = keys.iterator();
            while (iter != null && iter.hasNext()) {
                String ns = iter.next();
                if (jwm.getPackageNameForNamespaceURI(ns) != null) continue;
                jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.namespacePackageMap.get(ns), ns));
            }
        }
        return jwm;
    }

    private boolean isServerSideGeneration() {
        return this.serviceEndpointInterface != null;
    }

    private String getPackageName(String targetNamespace) {
        String pkg;
        if (this.namespacePackageMap != null && (pkg = this.namespacePackageMap.get(targetNamespace)) != null) {
            return pkg;
        }
        return this.packageName;
    }
}

