/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.PendingAction;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class VirtualServerSocket
extends ServerSocket
implements Serializable {
    private static final Logger log = Logger.getLogger((Class)VirtualServerSocket.class);
    private List acceptingThreads = Collections.synchronizedList(new LinkedList());
    private Map configuration = new HashMap();
    private MultiplexingManager manager;
    private MultiplexingInputStream is;
    private MultiplexingInputStream cis;
    private Protocol protocol;
    private Socket actualSocket;
    private int timeout;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Socket dummySocket;
    private static final long serialVersionUID = -5320724929164012313L;

    public VirtualServerSocket() throws IOException {
    }

    public VirtualServerSocket(int port) throws IOException {
        this.bind(new InetSocketAddress(port));
        log.debug((Object)("created VirtualServerSocket: " + this.toString()));
    }

    public VirtualServerSocket(int port, int backlog) throws IOException {
        this(port);
        log.warn((Object)"backlog parameter is ignored");
        log.debug((Object)("created VirtualServerSocket: " + this.toString()));
    }

    public VirtualServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this.bind(new InetSocketAddress(bindAddr, port));
        log.warn((Object)"backlog parameter is ignored");
        log.debug((Object)("created VirtualServerSocket: " + this.toString()));
    }

    public VirtualServerSocket(VirtualSocket socket, Map configuration) throws IOException {
        this.actualSocket = socket.getActualSocket();
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
        this.manager = socket.getManager();
        this.manager.incrementReferences();
        this.bind(new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort()));
        log.debug((Object)("created VirtualServerSocket: " + this.toString()));
    }

    public VirtualServerSocket(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, Map configuration) throws IOException {
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
        this.connect(remoteAddress, localAddress, timeout);
        log.debug((Object)("created VirtualServerSocket: " + this.toString()));
    }

    public synchronized Socket accept() throws IOException {
        log.debug((Object)"entering accept()");
        long start = System.currentTimeMillis();
        int timeout = this.getSoTimeout();
        int timeLeft = 0;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkAccept(this.actualSocket.getInetAddress().getHostAddress(), this.actualSocket.getPort());
        }
        Thread currentThread = Thread.currentThread();
        this.acceptingThreads.add(currentThread);
        VirtualSocket virtualSocket = null;
        try {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                log.error((Object)"timed out");
                throw new SocketTimeoutException("Accept timed out");
            }
            log.debug((Object)("timeLeft: " + timeLeft));
            SocketId clientPort = this.protocol.acceptConnect(this.is, timeLeft);
            log.debug((Object)("clientPort:  " + clientPort.getPort()));
            virtualSocket = new VirtualSocket(this.manager, clientPort, this.configuration);
            this.manager.incrementReferences();
            int localPort = virtualSocket.getLocalVirtualPort();
            this.protocol.answerConnect((MultiplexingOutputStream)virtualSocket.getOutputStream(), localPort);
            VirtualSocket virtualSocket2 = virtualSocket;
            return virtualSocket2;
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException || "Socket closed".equals(e.getMessage()) || "An existing connection was forcibly closed by the remote host".equals(e.getMessage())) {
                log.debug((Object)e);
            } else {
                log.error((Object)e);
            }
            if (virtualSocket != null) {
                virtualSocket.close();
            }
            if (this.isClosed()) {
                throw new SocketException("Socket closed");
            }
            if (e instanceof SocketTimeoutException) {
                throw new SocketTimeoutException("Accept timed out");
            }
            throw e;
        }
        finally {
            this.acceptingThreads.remove(currentThread);
            if (this.isClosed()) {
                if (virtualSocket != null) {
                    virtualSocket.close();
                }
                throw new SocketException("Socket closed");
            }
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 1);
    }

    public void bind(SocketAddress socketAddress, int backlog) throws IOException {
        if (backlog != 1) {
            log.warn((Object)"backlog != 1: ignored");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkListen(inetSocketAddress.getPort());
        }
        if (this.manager == null) {
            this.manager = MultiplexingManager.getaManagerByLocalAddress(inetSocketAddress, this.configuration);
            this.actualSocket = this.manager.getSocket();
        }
        try {
            this.bound = true;
            this.is = this.manager.registerServerSocket(this);
            this.cis = this.manager.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
            this.is.setTimeout(this.timeout);
            this.cis.setTimeout(this.timeout);
            if (this.manager.isConnected()) {
                this.protocol = this.manager.getProtocol();
                this.protocol.registerRemoteServerSocket(this.getSoTimeout());
                this.connected = true;
            }
        }
        catch (IOException e) {
            this.bound = false;
            if (this.manager.isServerSocketRegistered()) {
                this.manager.unRegisterServerSocket(this);
            }
            throw e;
        }
        log.debug((Object)this.toString());
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        if (!this.acceptingThreads.isEmpty()) {
            LinkedList threads = new LinkedList(this.acceptingThreads);
            Iterator it = threads.iterator();
            while (it.hasNext()) {
                Thread t = (Thread)it.next();
                t.interrupt();
                log.debug((Object)("interrupting accepting thread: " + t.getName()));
            }
            if (!this.acceptingThreads.isEmpty()) {
                MultiplexingManager.addToPendingActions(new PendingClose(this));
            }
        }
        if (this.protocol != null) {
            this.protocol.unregisterRemoteServerSocket();
        }
        if (this.manager != null) {
            this.manager.unRegisterServerSocket(this);
        }
    }

    public InetAddress getInetAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getInetAddress();
    }

    public int getLocalPort() {
        if (this.actualSocket == null) {
            return -1;
        }
        return this.actualSocket.getLocalPort();
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.actualSocket == null) {
            if (this.dummySocket == null) {
                this.dummySocket = new Socket();
            }
            return this.dummySocket.getReceiveBufferSize();
        }
        return this.actualSocket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.actualSocket == null) {
            return true;
        }
        return this.actualSocket.getReuseAddress();
    }

    public int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setReceiveBufferSize(size);
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setReuseAddress(on);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = timeout;
        if (this.is != null) {
            this.is.setTimeout(timeout);
        }
        if (this.cis != null) {
            this.cis.setTimeout(timeout);
        }
    }

    public String toString() {
        StringBuffer answer = new StringBuffer().append("VirtualServerSocket[");
        if (this.actualSocket == null) {
            answer.append("unbound");
        } else {
            answer.append(this.actualSocket.toString());
        }
        return answer.append("]").toString();
    }

    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, null, this.timeout);
    }

    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        this.connect(remoteAddress, localAddress, this.timeout);
    }

    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, int timeout) throws IOException {
        long start = System.currentTimeMillis();
        int timeLeft = 0;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress remoteInetSocketAddress = (InetSocketAddress)remoteAddress;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (remoteInetSocketAddress.isUnresolved()) {
                security.checkConnect(remoteInetSocketAddress.getHostName(), remoteInetSocketAddress.getPort());
            } else {
                security.checkConnect(remoteInetSocketAddress.getAddress().getHostAddress(), remoteInetSocketAddress.getPort());
            }
        }
        if (this.isConnected()) {
            if (this.getRemoteAddress().equals(remoteInetSocketAddress.getAddress())) {
                return;
            }
            throw new SocketException("already connected");
        }
        if (this.manager == null) {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("connect timed out");
            }
            if (localAddress == null) {
                this.manager = MultiplexingManager.getaManagerByRemoteAddress(remoteInetSocketAddress, timeLeft, this.configuration);
            } else {
                InetSocketAddress localInetSocketAddress = (InetSocketAddress)localAddress;
                this.manager = MultiplexingManager.getaManagerByAddressPair(remoteInetSocketAddress, localInetSocketAddress, timeLeft, this.configuration);
            }
        }
        this.actualSocket = this.manager.getSocket();
        try {
            if (!this.isBound()) {
                log.debug((Object)"calling registerServerSocket()");
                this.is = this.manager.registerServerSocket(this);
                this.cis = this.manager.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
                this.is.setTimeout(this.timeout);
                this.cis.setTimeout(this.timeout);
                this.bound = true;
            }
            if (!this.manager.isConnected()) {
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("connect timed out");
                }
                this.manager.connect(remoteInetSocketAddress, timeLeft);
                this.protocol = this.manager.getProtocol();
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("connect timed out");
                }
                this.cis.setTimeout(timeout);
                this.protocol.connect(this.cis, SocketId.SERVER_SOCKET_ID, timeLeft);
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("connect timed out");
                }
            } else {
                this.protocol = this.manager.getProtocol();
            }
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("connect timed out");
            }
            this.protocol.registerRemoteServerSocket(timeLeft);
        }
        catch (IOException e) {
            log.error((Object)"i/o exception in VirtualServerSocket.connect()", (Throwable)e);
            if (this.manager.isServerSocketRegistered()) {
                this.manager.unRegisterServerSocket(this);
            }
            if (e instanceof SocketTimeoutException) {
                throw new SocketTimeoutException("connect timed out");
            }
            throw e;
        }
        finally {
            if (this.cis != null) {
                this.cis.setTimeout(this.timeout);
            }
        }
        this.connected = true;
        log.debug((Object)this.toString());
    }

    public MultiplexingManager getMultiplexingManager() {
        return this.manager;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public InetAddress getRemoteAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getInetAddress();
    }

    public int getRemotePort() {
        if (this.actualSocket == null) {
            return 0;
        }
        return this.actualSocket.getPort();
    }

    public void setConfiguration(Map configuration) {
        this.configuration.putAll(configuration);
    }

    protected void doClose() {
        LinkedList threads = new LinkedList(this.acceptingThreads);
        Iterator it = threads.iterator();
        while (it.hasNext()) {
            Thread t = (Thread)it.next();
            t.interrupt();
            log.debug((Object)("interrupting accepting thread: " + t.getName()));
            while (this.acceptingThreads.contains(t)) {
                try {
                    log.debug((Object)("waiting for accepting thread to catch interrupt: " + t.getName()));
                    Thread.sleep(500L);
                    t.interrupt();
                    log.debug((Object)("interrupting accepting thread: " + t.getName()));
                }
                catch (InterruptedException ignored) {}
            }
        }
    }

    protected class PendingClose
    extends PendingAction {
        public PendingClose(Object o) {
            super(o);
        }

        public void doAction() {
            ((VirtualServerSocket)this.o).doClose();
        }
    }
}

