/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.container.jboss50.deployment.tomcat.WebMetaDataModifier;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class DynamicEndpointDeploymentAspect
extends DeploymentAspect {
    private static Logger log = Logger.getLogger(DynamicEndpointDeploymentAspect.class);
    private DeploymentFactory factory = new DeploymentFactory();
    private WebMetaDataModifier webMetaDataModifier;
    private DeployerClient mainDeployer;
    private Map<String, AbstractDeployment> deployments = new HashMap<String, AbstractDeployment>();

    public void setWebMetaDataModifier(WebMetaDataModifier webMetaDataModifier) {
        this.webMetaDataModifier = webMetaDataModifier;
    }

    public void setMainDeployer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void create(org.jboss.wsf.spi.deployment.Deployment dep) {
        JBossWebMetaData jbwmd = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (jbwmd == null) {
            throw new WebServiceException("Cannot find web meta data");
        }
        ClassLoader epLoader = dep.getRuntimeClassLoader();
        try {
            this.webMetaDataModifier.modifyMetaData(dep);
            String contextRoot = dep.getService().getContextRoot();
            AbstractDeployment deployment = this.createSimpleDeployment("http://jaxws-endpoint-api" + contextRoot);
            MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            mutableAttachments.addAttachment("org.jboss.ws.generated.webapp", (Object)Boolean.TRUE);
            mutableAttachments.addAttachment("org.jboss.web.explicitDocBase", (Object)"/", String.class);
            mutableAttachments.addAttachment(ClassLoaderFactory.class, (Object)new ContextClassLoaderFactory(epLoader));
            mutableAttachments.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
            mutableAttachments.addAttachment(Module.class, (Object)ClassLoading.getModuleForClassLoader((ClassLoader)epLoader));
            this.mainDeployer.deploy(new Deployment[]{deployment});
            this.deployments.put(contextRoot, deployment);
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    public void destroy(org.jboss.wsf.spi.deployment.Deployment dep) {
        try {
            String contextRoot = dep.getService().getContextRoot();
            AbstractDeployment deployment = this.deployments.remove(contextRoot);
            if (deployment != null) {
                this.mainDeployer.undeploy(new Deployment[]{deployment});
            }
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private AbstractDeployment createSimpleDeployment(String name) {
        AbstractDeployment unit = new AbstractDeployment(name);
        this.factory.addContext((PredeterminedManagedObjectAttachments)unit, "");
        return unit;
    }

    private static class ContextClassLoaderFactory
    implements ClassLoaderFactory {
        private ClassLoader classloader;

        public ContextClassLoaderFactory(ClassLoader classloader) {
            this.classloader = classloader;
        }

        public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
            return this.classloader;
        }

        public void removeClassLoader(DeploymentUnit unit) throws Exception {
            this.classloader = null;
        }
    }
}

