/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public abstract class AbstractPropertyHandler
extends AttributeHandler {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    protected boolean trace = this.log.isTraceEnabled();
    private PropertyInfo propertyInfo;
    private TypeInfo propertyType;

    public AbstractPropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType) {
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Null propertyInfo");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("Null propertyType");
        }
        this.propertyInfo = propertyInfo;
        this.propertyType = propertyType;
    }

    public PropertyInfo getPropertyInfo() {
        return this.propertyInfo;
    }

    public TypeInfo getPropertyType() {
        return this.propertyType;
    }

    public void doHandle(Object parent, Object child, QName qName) {
        if (this.trace) {
            this.log.trace((Object)("QName " + qName + " handle " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent) + " property=" + this.propertyInfo.getName()));
        }
        try {
            this.handle(this.propertyInfo, this.propertyType, parent, child, qName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + "error setting property " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent));
        }
    }

    public void attribute(QName elemName, QName attrName, AttributeBinding binding, Object owner, Object value) {
        ValueAdapter valueAdapter = binding.getValueAdapter();
        if (valueAdapter != null) {
            value = valueAdapter.cast(value, null);
        }
        BeanAdapter parent = (BeanAdapter)owner;
        this.doHandle(parent, value, attrName);
    }

    public abstract void handle(PropertyInfo var1, TypeInfo var2, Object var3, Object var4, QName var5);
}

