/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.jboss.xb.builder.JBossXBBuilder;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchemaResolver
implements SchemaBindingResolver {
    private static Logger log = Logger.getLogger(DefaultSchemaResolver.class);
    private String baseURI;
    private JBossEntityResolver resolver;
    private boolean cacheResolvedSchemas = true;
    private Map<String, SchemaBinding> schemasByUri = Collections.emptyMap();
    private WeakHashMap<String, Class> uriToClass = new WeakHashMap();
    private WeakHashMap<String, Class> schemaLocationToClass = new WeakHashMap();
    private Map<String, SchemaBindingInitializer> schemaInitByUri = Collections.emptyMap();
    private Map<String, Boolean> schemaParseAnnotationsByUri = Collections.emptyMap();

    public DefaultSchemaResolver() {
        this(new JBossEntityResolver());
    }

    public DefaultSchemaResolver(JBossEntityResolver resolver) {
        this.resolver = resolver;
    }

    public boolean isCacheResolvedSchemas() {
        return this.cacheResolvedSchemas;
    }

    public void setCacheResolvedSchemas(boolean cacheResolvedSchemas) {
        this.cacheResolvedSchemas = cacheResolvedSchemas;
        if (!cacheResolvedSchemas) {
            this.schemasByUri = Collections.emptyMap();
        }
    }

    public void addSchemaLocation(String nsUri, String location) {
        this.resolver.registerLocalEntity(nsUri, location);
    }

    public void removeSchemaLocation(String nsUri) {
        this.resolver.registerLocalEntity(nsUri, null);
    }

    public void addSchemaParseAnnotations(String nsUri, Boolean value) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        switch (this.schemaParseAnnotationsByUri.size()) {
            case 0: {
                this.schemaParseAnnotationsByUri = Collections.singletonMap(nsUri, value);
                break;
            }
            case 1: {
                this.schemaParseAnnotationsByUri = new HashMap<String, Boolean>(this.schemaParseAnnotationsByUri);
            }
            default: {
                this.schemaParseAnnotationsByUri.put(nsUri, value);
            }
        }
    }

    public Boolean removeSchemaParseAnnotations(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        return this.schemaParseAnnotationsByUri.remove(nsUri);
    }

    public void addSchemaInitializer(String nsUri, String sbiClassName) throws Exception {
        if (sbiClassName == null) {
            throw new IllegalArgumentException("Null class name");
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(sbiClassName);
        Object object = clazz.newInstance();
        if (!(object instanceof SchemaBindingInitializer)) {
            throw new IllegalArgumentException(clazz.getName() + " is not an instance of " + SchemaBindingInitializer.class.getName());
        }
        SchemaBindingInitializer sbi = (SchemaBindingInitializer)object;
        this.addSchemaInitializer(nsUri, sbi);
    }

    public void addSchemaInitializer(String nsUri, SchemaBindingInitializer sbi) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        if (sbi == null) {
            throw new IllegalArgumentException("Null schema binding initializer");
        }
        switch (this.schemaInitByUri.size()) {
            case 0: {
                this.schemaInitByUri = Collections.singletonMap(nsUri, sbi);
                break;
            }
            case 1: {
                this.schemaInitByUri = new HashMap<String, SchemaBindingInitializer>(this.schemaInitByUri);
            }
            default: {
                this.schemaInitByUri.put(nsUri, sbi);
            }
        }
    }

    public SchemaBindingInitializer removeSchemaInitializer(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        return this.schemaInitByUri.remove(nsUri);
    }

    public void addClassBinding(String nsUri, String reference) throws Exception {
        if (reference == null) {
            throw new IllegalArgumentException("Null reference class");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = cl.loadClass(reference);
        this.addClassBinding(nsUri, clazz);
    }

    public void addClassBinding(String nsUri, Class<?> clazz) {
        this.uriToClass.put(nsUri, clazz);
    }

    public Class<?> removeClassBinding(String nsUri) {
        return this.uriToClass.remove(nsUri);
    }

    public void addClassBindingForLocation(String schemaLocation, Class<?> clazz) {
        this.schemaLocationToClass.put(schemaLocation, clazz);
    }

    public Class<?> removeClassBindingForLocation(String schemaLocation) {
        return this.schemaLocationToClass.remove(schemaLocation);
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public SchemaBinding resolve(String nsURI, String baseURI, String schemaLocation) {
        boolean trace = log.isTraceEnabled();
        boolean foundByNS = false;
        SchemaBinding schema = this.schemasByUri.get(nsURI);
        if (schema != null) {
            if (trace) {
                log.trace((Object)("resolved cached schema, nsURI=" + nsURI + ", schema: " + schema));
            }
            return schema;
        }
        Class bindingClass = this.resolveClassFromSchemaLocation(schemaLocation, trace);
        if (bindingClass == null && (bindingClass = this.uriToClass.get(nsURI)) != null) {
            foundByNS = true;
        }
        if (bindingClass != null) {
            if (trace) {
                log.trace((Object)("found bindingClass, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation + ", class=" + bindingClass));
            }
            schema = JBossXBBuilder.build(bindingClass);
        } else {
            InputSource is = this.getInputSource(nsURI, baseURI, schemaLocation);
            if (trace) {
                String msg = (is == null ? "couldn't find" : "found") + " schema InputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation;
                log.trace((Object)msg);
            }
            if (is != null) {
                Boolean processAnnotationsBoolean;
                if (baseURI == null) {
                    baseURI = this.baseURI;
                }
                boolean processAnnotations = (processAnnotationsBoolean = this.schemaParseAnnotationsByUri.get(nsURI)) == null ? true : processAnnotationsBoolean;
                try {
                    schema = XsdBinder.bind(is.getByteStream(), null, baseURI, processAnnotations);
                    foundByNS = true;
                }
                catch (RuntimeException e) {
                    String msg = "Failed to parse schema for nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation;
                    throw new JBossXBRuntimeException(msg, e);
                }
            }
        }
        if (schema != null) {
            schema.setSchemaResolver(this);
            SchemaBindingInitializer sbi = this.schemaInitByUri.get(nsURI);
            if (sbi != null) {
                schema = sbi.init(schema);
            }
            if (schema != null && nsURI.length() > 0 && this.cacheResolvedSchemas && foundByNS) {
                if (this.schemasByUri.isEmpty()) {
                    this.schemasByUri = new HashMap<String, SchemaBinding>();
                }
                this.schemasByUri.put(nsURI, schema);
            }
        }
        if (trace) {
            log.trace((Object)("resolved schema: " + schema));
        }
        return schema;
    }

    protected Class<?> resolveClassFromSchemaLocation(String schemaLocation, boolean trace) {
        Class bindingClass;
        block6: {
            bindingClass = this.schemaLocationToClass.get(schemaLocation);
            if (bindingClass == null && schemaLocation != null && schemaLocation.length() > 0) {
                try {
                    int slash;
                    URI url = new URI(schemaLocation);
                    String path = url.getPath();
                    if (path == null) {
                        path = url.getSchemeSpecificPart();
                    }
                    String filename = (slash = path.lastIndexOf(47)) >= 0 ? path.substring(slash + 1) : path;
                    if (path.length() == 0) {
                        return null;
                    }
                    if (trace) {
                        log.trace((Object)("Mapped schemaLocation to filename: " + filename));
                    }
                    bindingClass = this.schemaLocationToClass.get(filename);
                }
                catch (URISyntaxException e) {
                    if (!trace) break block6;
                    log.trace((Object)"schemaLocation: is not a URI, using systemId as resource", (Throwable)e);
                }
            }
        }
        return bindingClass;
    }

    @Override
    public LSInput resolveAsLSInput(String nsURI, String baseURI, String schemaLocation) {
        LSInputAdaptor lsInput = null;
        InputSource is = this.getInputSource(nsURI, baseURI, schemaLocation);
        if (is != null) {
            String publicId = is.getPublicId();
            String systemId = is.getSystemId();
            lsInput = new LSInputAdaptor(publicId, systemId, baseURI);
            lsInput.setCharacterStream(is.getCharacterStream());
            lsInput.setByteStream(is.getByteStream());
            lsInput.setEncoding(is.getEncoding());
        }
        return lsInput;
    }

    private InputSource getInputSource(String nsURI, String baseURI, String schemaLocation) {
        InputSource is;
        boolean trace;
        block17: {
            block16: {
                block15: {
                    trace = log.isTraceEnabled();
                    is = null;
                    if (trace) {
                        log.trace((Object)("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation));
                    }
                    try {
                        is = this.resolver.resolveEntity(nsURI, schemaLocation);
                        if (trace) {
                            String msg = (is == null ? "Couldn't resolve" : "Resolved") + " schema using namespace as publicId and schemaLocation as systemId";
                            log.trace((Object)msg);
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block15;
                        log.trace((Object)"Failed to use nsUri/schemaLocation", (Throwable)e);
                    }
                }
                if (baseURI == null) {
                    baseURI = this.baseURI;
                }
                if (is == null && baseURI != null && schemaLocation != null) {
                    try {
                        URL url = new URL(baseURI);
                        url = new URL(url, schemaLocation);
                        String resolvedSchemaLocation = url.toString();
                        if (!schemaLocation.equals(resolvedSchemaLocation)) {
                            is = this.resolver.resolveEntity(null, url.toString());
                            if (trace && is != null) {
                                log.trace((Object)"Resolved schema location using baseURI");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block16;
                        log.trace((Object)"Failed to use schema location with baseURI", (Throwable)e);
                    }
                }
            }
            if (is == null && nsURI != null) {
                try {
                    is = this.resolver.resolveEntity(null, nsURI);
                    if (trace && is != null) {
                        log.trace((Object)"Resolved namespace as system id");
                    }
                }
                catch (Exception e) {
                    if (!trace) break block17;
                    log.trace((Object)"Failed to use namespace as system id", (Throwable)e);
                }
            }
        }
        if (trace) {
            log.trace((Object)("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation + ", is=" + is));
        }
        return is;
    }
}

