/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.spi.Configuration;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.annotations.JBossXmlMapEntry;
import org.jboss.xb.annotations.JBossXmlMapKey;
import org.jboss.xb.annotations.JBossXmlMapValue;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.builder.runtime.DefaultMapEntry;
import org.jboss.xb.spi.BeanAdapter;

public class MapPropertyHandler
extends AbstractPropertyHandler {
    private final MapFactory mapFactory;
    private final MapPutAdapter mapPutAdapter;

    public MapPropertyHandler(Configuration config, PropertyInfo propertyInfo, TypeInfo propertyType, boolean wrapped) {
        super(propertyInfo, propertyType);
        if (wrapped) {
            this.mapFactory = null;
        } else {
            ClassInfo classInfo = (ClassInfo)propertyType;
            if (Modifier.isAbstract(classInfo.getModifiers())) {
                this.mapFactory = HashMapFactory.INSTANCE;
            } else {
                ConstructorInfo constructor = classInfo.getDeclaredConstructor(null);
                if (constructor == null) {
                    for (ConstructorInfo ctor : classInfo.getDeclaredConstructors()) {
                        if (ctor.getParameterTypes().length != 0) continue;
                        this.log.warn((Object)("ClassInfo.getDeclaredConstructor(null) didn't work for " + classInfo.getName() + ", found the default ctor in ClassInfo.getDeclaredConstructors()"));
                        constructor = ctor;
                        break;
                    }
                    if (constructor == null) {
                        throw new RuntimeException("Default constructor not found for " + classInfo.getName());
                    }
                }
                this.mapFactory = new CtorMapFactory(constructor);
            }
        }
        JBossXmlMapEntry entry = (JBossXmlMapEntry)propertyInfo.getUnderlyingAnnotation(JBossXmlMapEntry.class);
        if (entry == null) {
            entry = (JBossXmlMapEntry)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlMapEntry.class);
        }
        if (entry != null && !JBossXmlMapEntry.DEFAULT.class.equals((Object)entry.type())) {
            BeanInfo entryBean = config.getBeanInfo(entry.type());
            this.mapPutAdapter = new CustomMapEntryPutAdapter(entryBean);
        } else {
            this.mapPutAdapter = DefaultMapEntryPutAdapter.INSTANCE;
        }
    }

    public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName qName) {
        if (this.trace) {
            this.log.trace((Object)("handle entry " + qName + ", property=" + propertyInfo.getName() + ", parent=" + parent + ", child=" + child));
        }
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        Map<Object, Object> m = null;
        if (this.mapFactory == null) {
            m = (Map<Object, Object>)beanAdapter.getValue();
        } else {
            try {
                if (propertyInfo.getGetter() != null) {
                    m = (Map)beanAdapter.get(propertyInfo);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("QName " + qName + " error getting map property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent), t);
            }
            if (m == null) {
                try {
                    m = this.mapFactory.createMap();
                }
                catch (Throwable t) {
                    throw new RuntimeException("QName " + qName + " error creating map: " + propertyType.getName(), t);
                }
                try {
                    beanAdapter.set(propertyInfo, m);
                }
                catch (Throwable t) {
                    throw new RuntimeException("QName " + qName + " error setting map property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent) + " with value " + BuilderUtil.toDebugString(m), t);
                }
            }
        }
        try {
            this.mapPutAdapter.put(m, child);
        }
        catch (Throwable e) {
            throw new RuntimeException("QName " + qName + " error adding " + BuilderUtil.toDebugString(child) + " to map " + BuilderUtil.toDebugString(m), e);
        }
    }

    private static class CtorMapFactory
    implements MapFactory {
        private final ConstructorInfo ctor;

        CtorMapFactory(ConstructorInfo ctor) {
            this.ctor = ctor;
        }

        public Map createMap() throws Throwable {
            return (Map)this.ctor.newInstance(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashMapFactory
    implements MapFactory {
        static final MapFactory INSTANCE = new HashMapFactory();

        private HashMapFactory() {
        }

        @Override
        public Map<Object, Object> createMap() {
            return new HashMap<Object, Object>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MapFactory {
        public Map<Object, Object> createMap() throws Throwable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultMapEntryPutAdapter
    implements MapPutAdapter {
        static final MapPutAdapter INSTANCE = new DefaultMapEntryPutAdapter();

        private DefaultMapEntryPutAdapter() {
        }

        @Override
        public void put(Map<Object, Object> map, Object entry) {
            if (!(entry instanceof DefaultMapEntry)) {
                throw new IllegalStateException("Expected DefaultMapEntry but got " + entry);
            }
            DefaultMapEntry defEntry = (DefaultMapEntry)entry;
            map.put(defEntry.getKey(), defEntry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomMapEntryPutAdapter
    implements MapPutAdapter {
        private final PropertyInfo keyProp;
        private final PropertyInfo valueProp;

        CustomMapEntryPutAdapter(BeanInfo entryBean) {
            PropertyInfo keyProp = null;
            PropertyInfo valueProp = null;
            for (PropertyInfo prop : entryBean.getProperties()) {
                JBossXmlMapValue value;
                JBossXmlMapKey key = (JBossXmlMapKey)prop.getUnderlyingAnnotation(JBossXmlMapKey.class);
                if (key != null) {
                    if (keyProp != null) {
                        throw new IllegalStateException("Found two properties in entry type " + entryBean.getName() + " annotated with @JBossXmlMapKey: " + keyProp.getName() + " and " + prop.getName());
                    }
                    keyProp = prop;
                }
                if ((value = (JBossXmlMapValue)prop.getUnderlyingAnnotation(JBossXmlMapValue.class)) == null) continue;
                if (valueProp != null) {
                    throw new IllegalStateException("Found two properties in entry type " + entryBean.getName() + " annotated with @JBossXmlMapValue: " + valueProp.getName() + " and " + prop.getName());
                }
                valueProp = prop;
            }
            if (keyProp == null) {
                throw new IllegalStateException("Entry type " + entryBean.getName() + " doesn't have any property annotated with @JBossXmlMapKey.");
            }
            this.keyProp = keyProp;
            this.valueProp = valueProp;
        }

        @Override
        public void put(Map<Object, Object> map, Object entry) throws Throwable {
            Object key = this.keyProp.get(entry);
            Object value = entry;
            if (this.valueProp != null) {
                value = this.valueProp.get(entry);
            }
            map.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MapPutAdapter {
        public void put(Map<Object, Object> var1, Object var2) throws Throwable;
    }
}

