/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.resolver;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.resolver.AbstractMutableSchemaResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassSchemaResolver
extends AbstractMutableSchemaResolver {
    private static Logger log = Logger.getLogger(MultiClassSchemaResolver.class);
    private Map<String, Class<?>[]> uriToClass = new HashMap<String, Class<?>[]>();
    private Map<String, Class<?>[]> schemaLocationToClass = new HashMap<String, Class<?>[]>();

    public MultiClassSchemaResolver() {
        super(log);
    }

    public MultiClassSchemaResolver(JBossEntityResolver resolver) {
        super(log, resolver);
    }

    @Override
    protected Class<?>[] getClassesForSchemaLocation(String uri) {
        return this.schemaLocationToClass.get(uri);
    }

    @Override
    protected Class<?>[] getClassesForURI(String uri) {
        return this.uriToClass.get(uri);
    }

    @Override
    public void mapLocationToClass(String schemaLocation, Class<?> clazz) {
        if (schemaLocation == null) {
            throw new IllegalArgumentException("schemaLocation is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        this.schemaLocationToClass.put(schemaLocation, new Class[]{clazz});
    }

    @Override
    public void mapLocationToClasses(String schemaLocation, Class<?> ... classes) {
        if (schemaLocation == null) {
            throw new IllegalArgumentException("schemaLocation is null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("classes is null");
        }
        this.schemaLocationToClass.put(schemaLocation, classes);
    }

    @Override
    public void mapURIToClass(String nsUri, Class<?> clazz) {
        if (nsUri == null) {
            throw new IllegalArgumentException("nsUri is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        this.uriToClass.put(nsUri, new Class[]{clazz});
    }

    @Override
    public void mapURIToClasses(String nsUri, Class<?> ... classes) {
        if (nsUri == null) {
            throw new IllegalArgumentException("schemaLocation is null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("classes is null");
        }
        this.uriToClass.put(nsUri, classes);
    }

    @Override
    public Class<?>[] removeLocationToClassMapping(String schemaLocation) {
        return this.schemaLocationToClass.remove(schemaLocation);
    }

    @Override
    public Class<?>[] removeURIToClassMapping(String nsUri) {
        return this.uriToClass.remove(nsUri);
    }
}

