/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.util;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.resolver.MultiClassSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.util.SchemaBindingValidator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaBindingValidator
implements SchemaBindingValidator {
    protected static final Logger log = Logger.getLogger(SchemaBindingValidator.class);
    protected static final QName WILDCARD = new QName("wildcard", "wildcard");
    protected Set<String> excludedNs = new HashSet<String>();
    protected Set<QName> excludedTypes = new HashSet<QName>();
    protected Set<QName> validatedTypes = new HashSet<QName>();
    protected Set<QName> validatedElements = new HashSet<QName>();
    private SchemaBindingResolver resolver;
    private boolean loggingEnabled = log.isTraceEnabled();

    protected AbstractSchemaBindingValidator() {
    }

    protected AbstractSchemaBindingValidator(SchemaBindingResolver resolver) {
        this();
        this.resolver = resolver;
    }

    public void reset() {
        this.validatedTypes.clear();
        this.validatedElements.clear();
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void enableLogging(boolean value) {
        this.loggingEnabled = value;
    }

    @Override
    public void excludeNs(String ns) {
        this.excludedNs.add(ns);
    }

    @Override
    public boolean isNsExcluded(String ns) {
        return this.excludedNs.contains(ns);
    }

    @Override
    public void includeNs(String ns) {
        this.excludedNs.remove(ns);
    }

    @Override
    public void excludeType(QName qName) {
        this.excludedTypes.add(qName);
    }

    @Override
    public boolean isTypeExcluded(QName qName) {
        return this.excludedTypes.contains(qName);
    }

    @Override
    public void includeType(QName qName) {
        this.excludedTypes.remove(qName);
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.resolver;
    }

    public void setSchemaResolver(SchemaBindingResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void validate(InputSource is, SchemaBinding binding) {
        SchemaBindingResolver resolver = binding.getSchemaResolver();
        if (resolver == null && (resolver = this.resolver) == null) {
            this.log("Schema resolver was not provided");
        }
        XSModel xsModel = Util.loadSchema(is, resolver);
        this.validate(xsModel, binding);
    }

    @Override
    public void validate(String xsdName, Class<?> ... cls) {
        XSModel xsModel;
        this.log("validate: " + xsdName + ", " + Arrays.asList(cls));
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("schema/" + xsdName);
        if (xsdUrl == null) {
            this.handleError("Failed to load schema from the classpath: schema/" + xsdName);
        }
        MultiClassSchemaResolver multiClassResolver = new MultiClassSchemaResolver();
        multiClassResolver.mapLocationToClasses(xsdName, cls);
        SchemaBinding binding = this.resolver.resolve("", null, xsdName);
        SchemaBindingResolver resolver = this.resolver;
        if (resolver == null) {
            resolver = multiClassResolver;
        }
        try {
            xsModel = Util.loadSchema(xsdUrl.openStream(), null, resolver);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read schema " + xsdName, e);
        }
        this.validate(xsModel, binding);
    }

    protected abstract void validate(XSModel var1, SchemaBinding var2);

    protected void handleError(String msg) {
        throw new IllegalStateException(msg);
    }

    protected void log(String msg) {
        if (this.loggingEnabled) {
            log.trace((Object)msg);
        }
    }
}

