/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import org.gradle.api.Project;
import org.jboss.gradle.plugins.jdocbook.JDocBookPlugin;

public class DirectoryLayout {
    private final Project project;
    private final JDocBookPlugin plugin;
    private File rootJDocBookSourceDirectory;
    private File targetDirectory;
    private File stagingDirectory;
    private File fontsDirectory;
    private File rootJDocBookWorkDirectory;
    private File rootJDocBookTranslationWorkDirectory;
    private File rootJDocBookProfileWorkDirectory;
    private File rootPublishDirectory;
    private File xslFoBaseDir;

    public DirectoryLayout(Project project, JDocBookPlugin plugin) {
        this.project = project;
        this.plugin = plugin;
    }

    private File getRootJDocBookSourceDirectory() {
        if (this.rootJDocBookSourceDirectory == null) {
            File src = new File(this.project.getProjectDir(), "src");
            File srcMain = new File(src, "main");
            this.rootJDocBookSourceDirectory = new File(srcMain, "docbook");
        }
        return this.rootJDocBookSourceDirectory;
    }

    public File getMasterSourceDirectory() {
        return this.getTranslationSourceDirectory(this.plugin.getConfiguration().getMasterLanguage());
    }

    public File getPotSourceDirectory() {
        return this.getTranslationSourceDirectory("pot");
    }

    public File getTranslationSourceDirectory(String language) {
        return new File(this.getRootJDocBookSourceDirectory(), language);
    }

    private File getTargetDirectory() {
        if (this.targetDirectory == null) {
            this.targetDirectory = new File(this.project.getBuildDir(), "docbook");
        }
        return this.targetDirectory;
    }

    public File getStagingDirectory() {
        if (this.stagingDirectory == null) {
            this.stagingDirectory = new File(this.getTargetDirectory(), "staging");
        }
        return this.stagingDirectory;
    }

    public File getFontsDirectory() {
        if (this.fontsDirectory == null) {
            this.fontsDirectory = new File(this.getStagingDirectory(), "fonts");
        }
        return this.fontsDirectory;
    }

    public File getRootJDocBookWorkDirectory() {
        if (this.rootJDocBookWorkDirectory == null) {
            this.rootJDocBookWorkDirectory = new File(this.getTargetDirectory(), "work");
        }
        return this.rootJDocBookWorkDirectory;
    }

    private File getRootJDocBookTranslationWorkDirectory() {
        if (this.rootJDocBookTranslationWorkDirectory == null) {
            this.rootJDocBookTranslationWorkDirectory = new File(this.getRootJDocBookWorkDirectory(), "translate");
        }
        return this.rootJDocBookTranslationWorkDirectory;
    }

    public File getTranslationDirectory(String language) {
        return new File(this.getRootJDocBookTranslationWorkDirectory(), language);
    }

    private File getRootJDocBookProfileWorkDirectory() {
        if (this.rootJDocBookProfileWorkDirectory == null) {
            this.rootJDocBookProfileWorkDirectory = new File(this.getRootJDocBookWorkDirectory(), "profile");
        }
        return this.rootJDocBookProfileWorkDirectory;
    }

    public File getProfilingDirectory(String language) {
        return new File(this.getRootJDocBookProfileWorkDirectory(), language);
    }

    private File getRootPublishDirectory() {
        if (this.rootPublishDirectory == null) {
            this.rootPublishDirectory = new File(this.getTargetDirectory(), "publish");
        }
        return this.rootPublishDirectory;
    }

    public File getPublishBaseDirectory(String language) {
        return new File(this.getRootPublishDirectory(), language);
    }

    public File getPublishDirectory(String language, String format) {
        return new File(this.getPublishBaseDirectory(language), format);
    }

    public File getXslFoBaseDir() {
        if (this.xslFoBaseDir == null) {
            this.xslFoBaseDir = new File(this.getRootJDocBookWorkDirectory(), "xsl-fo");
        }
        return this.xslFoBaseDir;
    }

    public File getXslFoDirectory(String language) {
        return new File(this.getXslFoBaseDir(), language);
    }
}

