/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import java.io.File;
import java.util.Locale;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;
import org.jboss.gradle.plugins.jdocbook.JDocBookPlugin;
import org.jboss.gradle.plugins.jdocbook.MasterSourceFileResolver;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.RenderingSource;
import org.jboss.jdocbook.util.StandardDocBookFormatMetadata;

public class GenerateXslFoTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(GenerateXslFoTask.class);
    private JDocBookPlugin plugin;
    private MasterSourceFileResolver masterSourceFileResolver;

    public void configure(JDocBookPlugin plugin, MasterSourceFileResolver masterSourceFileResolver) {
        this.plugin = plugin;
        this.masterSourceFileResolver = masterSourceFileResolver;
    }

    @TaskAction
    public void generate() {
        log.lifecycle("Generating XSL-FO file");
        FormatOptions pdfFormatOptions = this.findPdfFormatOptions();
        log.trace("found pdf format options");
        this.plugin.getComponentRegistry().getXslFoGenerator().generateXslFo((RenderingSource)new RenderingSourceImpl(), pdfFormatOptions);
    }

    private FormatOptions findPdfFormatOptions() {
        for (FormatOptions formatOptions : this.plugin.getConfiguration().getFormats()) {
            if (!StandardDocBookFormatMetadata.PDF.getName().equals(formatOptions.getName())) continue;
            return formatOptions;
        }
        throw new JDocBookProcessException("Could not locate PDF format options");
    }

    private class RenderingSourceImpl
    implements RenderingSource {
        private RenderingSourceImpl() {
        }

        private String masterLanguage() {
            return GenerateXslFoTask.this.plugin.getConfiguration().getMasterLanguage();
        }

        public Locale getLanguage() {
            return GenerateXslFoTask.this.plugin.fromLanguageString(this.masterLanguage());
        }

        public File resolveSourceDocument() {
            return GenerateXslFoTask.this.masterSourceFileResolver.getMainMasterFile();
        }

        public File getXslFoDirectory() {
            return GenerateXslFoTask.this.plugin.getDirectoryLayout().getXslFoDirectory(this.masterLanguage());
        }

        public File resolvePublishingBaseDirectory() {
            return null;
        }
    }
}

