/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.util.ConfigureUtil;
import org.jboss.jdocbook.Profiling;
import org.jboss.jdocbook.ValueInjection;
import org.jboss.jdocbook.render.FormatOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDocBookConfiguration {
    public static final String DEFAULT_STANDARD_DATE_INJECTION_FORMAT = "yyyy-MM-dd";
    private String masterSourceDocumentName = "book.xml";
    private String masterLanguage = "en-US";
    private Set<String> translations = new HashSet<String>();
    private Profiling profiling = new Profiling();
    private Set<FormatOptions> formats = new HashSet<FormatOptions>();
    private LinkedHashSet<String> catalogs = new LinkedHashSet();
    private char localeSeparator = (char)45;
    private boolean useRelativeImageUris = true;
    private boolean autoDetectFonts = false;
    private boolean useFopFontCache = true;
    private LinkedHashSet<ValueInjection> valueInjections = new LinkedHashSet();
    private boolean applyStandardInjectionValues = true;
    private String injectionDateFormat = "yyyy-MM-dd";
    private Properties transformerParameters;

    public String getMasterSourceDocumentName() {
        return this.masterSourceDocumentName;
    }

    public String getMasterLanguage() {
        return this.masterLanguage;
    }

    public Set<String> getTranslations() {
        return this.translations;
    }

    public void translation(String translation) {
        this.translations.add(translation);
    }

    public void translations(String[] translations) {
        this.translations.addAll(Arrays.asList(translations));
    }

    public Profiling getProfiling() {
        return this.profiling;
    }

    public void profiling(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.profiling);
    }

    public void profiling(Map<String, ?> settings) {
        ConfigureUtil.configureByMap(settings, (Object)this.profiling);
    }

    public Set<FormatOptions> getFormats() {
        return this.formats;
    }

    public void format(Closure closure) {
        FormatOptionsImpl formatOptions = new FormatOptionsImpl();
        ConfigureUtil.configure((Closure)closure, (Object)formatOptions);
        this.formats.add(formatOptions);
    }

    public void format(Map<String, ?> settings) {
        FormatOptionsImpl formatOptions = new FormatOptionsImpl();
        ConfigureUtil.configureByMap(settings, (Object)formatOptions);
        this.formats.add(formatOptions);
    }

    public LinkedHashSet<String> getCatalogs() {
        return this.catalogs;
    }

    public void catalog(String catalog) {
        this.catalogs.add(catalog);
    }

    public char getLocaleSeparator() {
        return this.localeSeparator;
    }

    public boolean isUseRelativeImageUris() {
        return this.useRelativeImageUris;
    }

    public boolean isAutoDetectFonts() {
        return this.autoDetectFonts;
    }

    public boolean isUseFopFontCache() {
        return this.useFopFontCache;
    }

    public LinkedHashSet<ValueInjection> getValueInjections() {
        return this.valueInjections;
    }

    public void valueInjection(Closure closure) {
        ValueInjection injection = new ValueInjection();
        ConfigureUtil.configure((Closure)closure, (Object)injection);
        this.valueInjections.add(injection);
    }

    public void valueInjection(Map<String, ?> settings) {
        ValueInjection injection = new ValueInjection();
        ConfigureUtil.configureByMap(settings, (Object)injection);
        this.valueInjections.add(injection);
    }

    public boolean isApplyStandardInjectionValues() {
        return this.applyStandardInjectionValues;
    }

    public String getInjectionDateFormat() {
        return this.injectionDateFormat;
    }

    public Properties getTransformerParameters() {
        return this.transformerParameters;
    }

    public static class FormatOptionsImpl
    implements FormatOptions {
        private String name;
        private String finalName;
        private String stylesheet;

        public String getName() {
            return this.name;
        }

        public String getTargetFinalName() {
            return this.finalName;
        }

        public String getStylesheetResource() {
            return this.stylesheet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormatOptionsImpl that = (FormatOptionsImpl)o;
            if (this.finalName != null ? !this.finalName.equals(that.finalName) : that.finalName != null) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.stylesheet != null ? !this.stylesheet.equals(that.stylesheet) : that.stylesheet != null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.finalName != null ? this.finalName.hashCode() : 0);
            result = 31 * result + (this.stylesheet != null ? this.stylesheet.hashCode() : 0);
            return result;
        }
    }
}

