/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.manager.history.operation.OperationHistoryManager;
import org.jboss.on.embedded.ui.CommonActionUtil;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Name(value="operationAction")
@Scope(value=ScopeType.CONVERSATION)
public class SingleResourceOperationAction
implements Serializable {
    @In
    private transient FacesMessages facesMessages;
    @In
    private OperationHistoryManager historyManager;
    @Out(required=false)
    private OperationHistory selectedHistory;
    @In(create=true)
    private CommonActionUtil commonActionUtil;
    @Out(required=false)
    private Resource currentResource;
    @Out(required=false)
    private List<OperationDefinition> operations = new ArrayList();
    @Out(required=false)
    private List<ResourceOperationHistory> operationHistories;
    Map<Integer, ResourceOperationHistory> operationHistoryMap = new HashMap();
    @Out(required=false)
    private OperationDefinition selectedOperation;
    @Out(required=false)
    private Configuration selectedOperationParameters;
    @RequestParameter
    private String selectedOperationName;

    @Begin(join=true)
    public void initOperationsAndHistory() {
        this.currentResource = this.commonActionUtil.getCurrentResource();
        this.initOperations();
        this.initHistories();
    }

    public String invokeOperation() {
        ResourceType resourceType = this.getResourceType();
        OperationDefinition operationDef = SingleResourceOperationAction.getOperationDefinition((ResourceType)resourceType, (String)this.selectedOperationName);
        ConfigurationDefinition paramDef = operationDef.getParametersConfigurationDefinition();
        if (paramDef != null && !paramDef.getPropertyDefinitions().isEmpty() && this.selectedOperationParameters == null) {
            this.initSelectedOperationInfo();
            return "missingParams";
        }
        OperationHistory newOperationHistory = this.historyManager.addOperationHistory(operationDef.getName(), this.selectedOperationParameters, this.currentResource, resourceType);
        this.selectedOperationParameters = null;
        ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
        String jobId = newOperationHistory.getJobId().toString();
        try {
            resourceManager.invokeOperation(this.currentResource, operationDef, newOperationHistory.getParameters(), jobId);
            this.facesMessages.add("The #0 operation has been invoked. See the operation history below for the results once the operation has completed.", new Object[]{operationDef.getName()});
        }
        catch (RuntimeException e) {
            newOperationHistory.setStatus(OperationRequestStatus.FAILURE);
            newOperationHistory.setErrorMessageFromThrowable((Throwable)e);
            this.facesMessages.add(FacesMessage.SEVERITY_FATAL, "Failed to invoke operation: #0", new Object[]{e});
        }
        this.initHistories();
        this.selectOperationHistory(newOperationHistory.getId());
        return "success";
    }

    public void selectOperationHistory(int id) {
        this.selectedHistory = this.getOperationHistory(id);
    }

    public String getOperationRowStyleClass(OperationDefinition operation) {
        int rowNumber;
        String styleClass = "";
        if (operation != null && this.operations != null && (rowNumber = this.operations.indexOf(operation)) == this.operations.size() - 1) {
            styleClass = "controlTriggerPanelLast";
        }
        return styleClass;
    }

    public String getHistoriesTableRowStyleClass(OperationHistory history) {
        String styleClass = history.equals((Object)this.selectedHistory) ? "selectedRow" : "";
        return styleClass;
    }

    public ResourceOperationHistory getOperationHistory(int opHistoryId) {
        return (ResourceOperationHistory)this.operationHistoryMap.get(opHistoryId);
    }

    private ResourceType getResourceType() {
        this.currentResource = this.commonActionUtil.getCurrentResource();
        ResourceType resourceType = this.currentResource.getResourceType();
        return resourceType;
    }

    private void initOperations() {
        ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
        this.operations = resourceManager.getOperationsForResource(this.currentResource);
    }

    private void initHistories() {
        Collection opHistories = this.historyManager.getHistoryForResource(this.currentResource);
        if (opHistories != null) {
            this.operationHistories = new ArrayList();
            for (OperationHistory opHistory : opHistories) {
                ResourceOperationHistory resourceOpHistory = (ResourceOperationHistory)opHistory;
                this.operationHistories.add(resourceOpHistory);
                this.operationHistoryMap.put(resourceOpHistory.getId(), resourceOpHistory);
            }
            Collections.sort(this.operationHistories, new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.operationHistories = null;
        }
    }

    public Map<Integer, ResourceOperationHistory> getOperationHistoryMap() {
        return this.operationHistoryMap;
    }

    private void initSelectedOperationInfo() {
        ResourceType resourceType = this.getResourceType();
        this.selectedOperation = SingleResourceOperationAction.getOperationDefinition((ResourceType)resourceType, (String)this.selectedOperationName);
        ConfigurationTemplate defaultTemplate = this.selectedOperation.getParametersConfigurationDefinition().getDefaultTemplate();
        this.selectedOperationParameters = defaultTemplate != null ? defaultTemplate.getConfiguration().deepCopy() : new Configuration();
    }

    private static OperationDefinition getOperationDefinition(ResourceType resourceType, String operationName) {
        Set operationDefs = resourceType.getOperationDefinitions();
        for (OperationDefinition operationDef : operationDefs) {
            if (!operationDef.getName().equals(operationName)) continue;
            return operationDef;
        }
        return null;
    }
}

