/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.configuration.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.on.embedded.bean.ConfigTemplateSelectUtil;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.NavigationAction;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.SubCategoryTreeNode;
import org.jboss.on.embedded.ui.nav.TreeNodeWithResourceType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="templateDropDownPopulator")
public class TemplateDropDownPopulator {
    private Map<String, String> templateMap;
    private ResourceManager configurationManager = ResourceManagerFactory.resourceManager();
    private String selectedTemplate;
    @In(value="navigationAction", required=false)
    NavigationAction navigationAction;
    @Out(value="serviceType", required=false, scope=ScopeType.CONVERSATION)
    private ResourceType serviceType;
    @Out(value="templateConfiguration", required=false, scope=ScopeType.CONVERSATION)
    private Configuration template;
    @Out(value="ancestorResource", required=false, scope=ScopeType.CONVERSATION)
    private Resource ancestorResource;
    @RequestParameter
    private String selectedSubCategoryPath;
    @RequestParameter
    String selectedResourceTypeName;

    public void populateFromTemplate() {
        String selectedTemplateName = ConfigTemplateSelectUtil.getTemplateName((String)this.selectedTemplate);
        String selectedResourceTypeName = ConfigTemplateSelectUtil.getResourceTypeName((String)this.selectedTemplate);
        JONTreeNode currentNode = this.navigationAction.getSelectedNode();
        this.ancestorResource = currentNode.getClosestResource();
        this.serviceType = this.configurationManager.getResourceType(selectedResourceTypeName);
        Map templates = this.serviceType.getResourceConfigurationDefinition().getTemplates();
        Configuration originalTemplate = ((ConfigurationTemplate)templates.get(selectedTemplateName)).getConfiguration();
        this.template = originalTemplate.deepCopy();
        ConfigurationUtility.normalizeConfiguration((Configuration)this.template, (ConfigurationDefinition)this.serviceType.getResourceConfigurationDefinition());
    }

    public String getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public void setSelectedTemplate(String selectedTemplate) {
        this.selectedTemplate = selectedTemplate;
    }

    @Begin
    public void getTemplateDropDownEntriesBySubCategory() {
        this.templateMap = new LinkedHashMap();
        this.templateMap.put("Select Template", "");
        JONTreeNode treeNode = this.navigationAction.findNode(this.selectedSubCategoryPath);
        if (treeNode instanceof SubCategoryTreeNode) {
            SubCategoryTreeNode subCategoryNode = (SubCategoryTreeNode)treeNode;
            for (JONTreeNode childNode : subCategoryNode.getChildNodes()) {
                if (!(childNode instanceof TreeNodeWithResourceType)) continue;
                TreeNodeWithResourceType nodeWithResourceType = (TreeNodeWithResourceType)childNode;
                ResourceType resourceType = nodeWithResourceType.getResourceType();
                Map templates = resourceType.getResourceConfigurationDefinition().getTemplates();
                ConfigTemplateSelectUtil.populateSelectItemsMap((Map)this.templateMap, templates.keySet(), (String)resourceType.getName());
            }
        } else {
            throw new IllegalArgumentException("Path [" + this.selectedSubCategoryPath + "] should point to a SubCategoryTreeNode but did not.");
        }
    }

    @Begin
    public void getTemplateDropDownEntriesByResourceType() {
        this.templateMap = new LinkedHashMap();
        this.templateMap.put("Select Template", "");
        ResourceType serviceType = this.configurationManager.getResourceType(this.selectedResourceTypeName);
        Map templates = serviceType.getResourceConfigurationDefinition().getTemplates();
        ConfigTemplateSelectUtil.populateSelectItemsMap((Map)this.templateMap, templates.keySet(), (String)serviceType.getName());
    }

    @Out(required=false, scope=ScopeType.CONVERSATION)
    public Map getTemplateMap() {
        return this.templateMap;
    }

    @In(required=false)
    public void setTemplateMap(Map<String, String> templateMap) {
        this.templateMap = templateMap;
    }
}

