/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.ui.BootstrapAction;
import org.jboss.on.embedded.ui.NavigationAction;
import org.jboss.seam.annotations.In;
import org.jboss.seam.faces.FacesMessages;

public abstract class AbstractFileUploadAction {
    protected static final String SUCCESS_OUTCOME = "success";
    protected static final String FAILURE_OUTCOME = "failure";
    protected static final String PACKAGE_ARCHITECTURE = "no-arch";
    private final Log log = LogFactory.getLog(this.getClass());
    private String fileName;
    private byte[] file;
    private String fileContentType;
    @In
    protected transient FacesMessages facesMessages;
    @In
    protected NavigationAction navigationAction;
    @In
    private BootstrapAction bootstrapAction;

    protected File writeTempFile() throws IOException {
        File tempFile;
        File tempDir = this.bootstrapAction.getTempDir();
        File uploadsDir = new File(tempDir, "uploads");
        try {
            uploadsDir.mkdirs();
            tempFile = new File(uploadsDir, this.fileName);
            this.log.debug((Object)("Writing uploaded file to '" + tempFile + "'..."));
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(this.file);
            this.log.debug((Object)("Wrote " + this.file.length + " bytes to '" + tempFile + "'."));
            fos.close();
        }
        catch (IOException e) {
            this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.create.unableToCreateTempFile", new Object[0]);
            this.log.error((Object)("Unable to save uploaded file to temp directory " + tempDir + "."), (Throwable)e);
            throw e;
        }
        return tempFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getFile() {
        return this.file;
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public String getFileContentType() {
        return this.fileContentType;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }
}

