/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.resolvers;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.javaee.JavaEEModuleInformer;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.metadata.jpa.spec.PersistenceMetaData;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;

public class DefaultPersistenceUnitDependencyResolver
implements PersistenceUnitDependencyResolver {
    private JavaEEModuleInformer javaEEModuleInformer;

    public String createBeanName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        assert (persistenceUnitName.indexOf(47) == -1);
        assert (persistenceUnitName.indexOf(35) == -1);
        String appName = this.javaEEModuleInformer.getApplicationName(deploymentUnit);
        String modulePath = this.javaEEModuleInformer.getModulePath(deploymentUnit);
        String unitName = (appName != null ? appName + "/" : "") + modulePath + "#" + persistenceUnitName;
        return "persistence.unit:unitName=" + unitName;
    }

    private String findWithinApplication(DeploymentUnit unit, String persistenceUnitName) {
        String name = this.findWithinModule(unit, persistenceUnitName, false);
        if (name != null) {
            return name;
        }
        for (DeploymentUnit child : unit.getChildren()) {
            name = this.findWithinApplication(child, persistenceUnitName);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private String findWithinModule(DeploymentUnit unit, String persistenceUnitName, boolean allowScoped) {
        if (!allowScoped && this.isScoped(unit)) {
            return null;
        }
        PersistenceMetaData persistenceMetaData = (PersistenceMetaData)unit.getAttachment(PersistenceMetaData.class);
        if (persistenceMetaData == null) {
            return null;
        }
        for (PersistenceUnitMetaData persistenceUnit : persistenceMetaData.getPersistenceUnits()) {
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getName().equals(persistenceUnitName)) continue;
            return this.createBeanName(unit, persistenceUnit.getName());
        }
        return null;
    }

    private static DeploymentUnit getDeploymentUnit(DeploymentUnit current, String path) {
        if (path.startsWith("/")) {
            return DefaultPersistenceUnitDependencyResolver.getDeploymentUnit(current.getTopLevel(), path.substring(1));
        }
        if (path.startsWith("./")) {
            return DefaultPersistenceUnitDependencyResolver.getDeploymentUnit(current, path.substring(2));
        }
        if (path.startsWith("../")) {
            return DefaultPersistenceUnitDependencyResolver.getDeploymentUnit(current.getParent(), path.substring(3));
        }
        int i = path.indexOf(47);
        String name = i == -1 ? path : path.substring(0, i);
        for (DeploymentUnit child : current.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        throw new IllegalArgumentException("Can't find a deployment unit named " + name + " at " + current);
    }

    private boolean isScoped(DeploymentUnit unit) {
        JavaEEModuleInformer.ModuleType type = this.javaEEModuleInformer.getModuleType(unit);
        if (type == JavaEEModuleInformer.ModuleType.APP_CLIENT) {
            return true;
        }
        if (type == JavaEEModuleInformer.ModuleType.EJB) {
            return true;
        }
        return type == JavaEEModuleInformer.ModuleType.WEB;
    }

    public String resolvePersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        int i;
        int n = i = persistenceUnitName == null ? -1 : persistenceUnitName.indexOf(35);
        if (i != -1) {
            String path = persistenceUnitName.substring(0, i);
            String unitName = persistenceUnitName.substring(i + 1);
            DeploymentUnit targetDeploymentUnit = DefaultPersistenceUnitDependencyResolver.getDeploymentUnit(deploymentUnit, path);
            return this.createBeanName(targetDeploymentUnit, unitName);
        }
        String name = this.findWithinModule(deploymentUnit, persistenceUnitName, true);
        if (name == null) {
            name = this.findWithinApplication(deploymentUnit.getTopLevel(), persistenceUnitName);
        }
        if (name == null) {
            throw new IllegalArgumentException("Can't find a persistence unit named '" + persistenceUnitName + "' in " + deploymentUnit);
        }
        return name;
    }

    @Inject
    public void setJavaEEModuleInformer(JavaEEModuleInformer informer) {
        this.javaEEModuleInformer = informer;
    }
}

